/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.AccessController;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.jspecify.annotations.Nullable;

public class DefaultAccessController
implements AccessController {
    private final OpcUaServer server;

    public DefaultAccessController(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public Map<ReadValueId, AccessController.AccessResult> checkReadAccess(Session session, List<ReadValueId> readValueIds) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkReadAccess(context, readValueIds);
    }

    static Map<ReadValueId, AccessController.AccessResult> checkReadAccess(AccessControlContext context, List<ReadValueId> readValueIds) {
        List pending = readValueIds.stream().map(PendingResult::new).toList();
        List<NodeId> nodeIds = readValueIds.stream().map(ReadValueId::getNodeId).toList();
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, ReadValueId::getNodeId);
        for (PendingResult p2 : pending) {
            boolean hasAccess;
            if (p2.result.isDenied()) continue;
            NodeId nodeId = ((ReadValueId)p2.value).getNodeId();
            UInteger attributeId = ((ReadValueId)p2.value).getAttributeId();
            if (AttributeId.Value.uid().equals((Object)attributeId)) {
                EnumSet accessLevels;
                UByte userAccessLevel = attributes.get(nodeId).userAccessLevel();
                if (userAccessLevel == null || (accessLevels = AccessLevel.fromValue((UByte)userAccessLevel)).contains(AccessLevel.CurrentRead)) continue;
                p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
                continue;
            }
            if (!AttributeId.RolePermissions.uid().equals((Object)attributeId)) continue;
            List roleIds = context.getRoleIds().orElse(null);
            RolePermissionType[] userRolePermissions = attributes.get(nodeId).userRolePermissions();
            if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getReadRolePermissions()))) continue;
            p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        return pending.stream().collect(Collectors.toMap(p -> (ReadValueId)p.value, p -> p.result, (a, b) -> b));
    }

    @Override
    public Map<WriteValue, AccessController.AccessResult> checkWriteAccess(Session session, List<WriteValue> writeValues) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkWriteAccess(context, writeValues);
    }

    static Map<WriteValue, AccessController.AccessResult> checkWriteAccess(AccessControlContext context, List<WriteValue> writeValues) {
        List pending = writeValues.stream().map(PendingResult::new).toList();
        List<NodeId> nodeIds = writeValues.stream().map(WriteValue::getNodeId).toList();
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, WriteValue::getNodeId);
        for (PendingResult p2 : pending) {
            EnumSet userWriteMasks;
            boolean hasAccess;
            RolePermissionType[] userRolePermissions;
            List roleIds;
            if (p2.result.isDenied()) continue;
            NodeId nodeId = ((WriteValue)p2.value).getNodeId();
            UInteger attributeId = ((WriteValue)p2.value).getAttributeId();
            if (AttributeId.Value.uid().equals((Object)attributeId)) {
                EnumSet accessLevels;
                UByte userAccessLevel = attributes.get(nodeId).userAccessLevel();
                if (userAccessLevel == null || (accessLevels = AccessLevel.fromValue((UByte)userAccessLevel)).contains(AccessLevel.CurrentWrite)) continue;
                p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
                continue;
            }
            if (AttributeId.RolePermissions.uid().equals((Object)attributeId)) {
                roleIds = context.getRoleIds().orElse(null);
                userRolePermissions = attributes.get(nodeId).userRolePermissions();
                if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getWriteRolePermissions()))) continue;
                p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
                continue;
            }
            if (AttributeId.Historizing.uid().equals((Object)attributeId)) {
                roleIds = context.getRoleIds().orElse(null);
                userRolePermissions = attributes.get(nodeId).userRolePermissions();
                if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getWriteHistorizing()))) continue;
                p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
                continue;
            }
            UInteger userWriteMask = attributes.get(nodeId).userWriteMask();
            EnumSet enumSet = userWriteMasks = userWriteMask == null ? Set.of() : WriteMask.fromMask((UInteger)userWriteMask);
            hasAccess = AttributeId.from((UInteger)attributeId).map(id -> userWriteMasks.contains(WriteMask.forAttribute((AttributeId)id))).orElse(false);
            if (hasAccess) continue;
            p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        return pending.stream().collect(Collectors.toMap(p -> (WriteValue)p.value, p -> p.result, (a, b) -> b));
    }

    @Override
    public Map<NodeId, AccessController.AccessResult> checkBrowseAccess(Session session, List<NodeId> nodeIds) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkBrowseAccess(context, nodeIds);
    }

    static Map<NodeId, AccessController.AccessResult> checkBrowseAccess(AccessControlContext context, List<NodeId> nodeIds) {
        List pending = nodeIds.stream().map(PendingResult::new).toList();
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkBrowseAccessRestrictions(context, pending, attributes, Function.identity());
        for (PendingResult p2 : pending) {
            boolean hasAccess;
            if (p2.result.isDenied()) continue;
            NodeId nodeId = (NodeId)p2.value;
            List roleIds = context.getRoleIds().orElse(null);
            RolePermissionType[] userRolePermissions = attributes.get(nodeId).userRolePermissions();
            if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getBrowse()))) continue;
            p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        return pending.stream().collect(Collectors.toMap(p -> (NodeId)p.value, p -> p.result, (a, b) -> b));
    }

    @Override
    public Map<CallMethodRequest, AccessController.AccessResult> checkCallAccess(Session session, List<CallMethodRequest> requests) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkCallAccess(context, requests);
    }

    static Map<CallMethodRequest, AccessController.AccessResult> checkCallAccess(AccessControlContext context, List<CallMethodRequest> requests) {
        List pending = requests.stream().flatMap(r -> Stream.of(new PendingResult<NodeId>(r.getObjectId()), new PendingResult<NodeId>(r.getMethodId()))).toList();
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>();
        for (CallMethodRequest request : requests) {
            nodeIds.add(request.getObjectId());
            nodeIds.add(request.getMethodId());
        }
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, Function.identity());
        for (int i = 0; i < pending.size(); i += 2) {
            Boolean userExecutable;
            PendingResult p0 = pending.get(i);
            PendingResult p1 = pending.get(i + 1);
            if (p0.result.isDenied() || p1.result.isDenied()) continue;
            AccessControlAttributes objectAttributes = attributes.get(p0.value);
            AccessControlAttributes methodAttributes = attributes.get(p1.value);
            RolePermissionType[] objectPermissions = objectAttributes.userRolePermissions();
            RolePermissionType[] methodPermissions = methodAttributes.userRolePermissions();
            List roleIds = context.getRoleIds().orElse(null);
            if (roleIds != null && objectPermissions != null && methodPermissions != null) {
                boolean objectPermission = Stream.of(objectPermissions).anyMatch(rp -> rp.getPermissions().getCall());
                boolean methodPermission = Stream.of(methodPermissions).anyMatch(rp -> rp.getPermissions().getCall());
                if (!objectPermission || !methodPermission) {
                    p0.result = AccessController.AccessResult.DENIED_USER_ACCESS;
                    p1.result = AccessController.AccessResult.DENIED_USER_ACCESS;
                }
            }
            if ((userExecutable = methodAttributes.userExecutable()) == null || userExecutable.booleanValue()) continue;
            p1.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        HashMap<CallMethodRequest, AccessController.AccessResult> results = new HashMap<CallMethodRequest, AccessController.AccessResult>();
        for (int i = 0; i < pending.size(); i += 2) {
            CallMethodRequest request = requests.get(i / 2);
            PendingResult p0 = pending.get(i);
            PendingResult p1 = pending.get(i + 1);
            boolean allowed = p0.result.isAllowed() && p1.result.isAllowed();
            results.put(request, allowed ? AccessController.AccessResult.ALLOWED : AccessController.AccessResult.DENIED_USER_ACCESS);
        }
        return results;
    }

    @Override
    public Map<AddReferencesItem, AccessController.AccessResult> checkAddReferencesAccess(Session session, List<AddReferencesItem> referencesToAdd) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkAddReferencesAccess(context, referencesToAdd);
    }

    static Map<AddReferencesItem, AccessController.AccessResult> checkAddReferencesAccess(AccessControlContext context, List<AddReferencesItem> referencesToAdd) {
        List pending = referencesToAdd.stream().map(PendingResult::new).toList();
        List<NodeId> nodeIds = referencesToAdd.stream().map(AddReferencesItem::getSourceNodeId).toList();
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, AddReferencesItem::getSourceNodeId);
        for (PendingResult p2 : pending) {
            boolean hasAccess;
            if (p2.result.isDenied()) continue;
            NodeId nodeId = ((AddReferencesItem)p2.value).getSourceNodeId();
            List roleIds = context.getRoleIds().orElse(null);
            RolePermissionType[] userRolePermissions = attributes.get(nodeId).userRolePermissions();
            if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getAddReference()))) continue;
            p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        return pending.stream().collect(Collectors.toMap(p -> (AddReferencesItem)p.value, p -> p.result, (a, b) -> b));
    }

    @Override
    public Map<DeleteNodesItem, AccessController.AccessResult> checkDeleteNodesAccess(Session session, List<DeleteNodesItem> nodesToDelete) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkDeleteNodesAccess(context, nodesToDelete);
    }

    static Map<DeleteNodesItem, AccessController.AccessResult> checkDeleteNodesAccess(AccessControlContext context, List<DeleteNodesItem> nodesToDelete) {
        List pending = nodesToDelete.stream().map(PendingResult::new).toList();
        List<NodeId> nodeIds = nodesToDelete.stream().map(DeleteNodesItem::getNodeId).toList();
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, DeleteNodesItem::getNodeId);
        for (PendingResult p2 : pending) {
            boolean hasAccess;
            if (p2.result.isDenied()) continue;
            NodeId nodeId = ((DeleteNodesItem)p2.value).getNodeId();
            List roleIds = context.getRoleIds().orElse(null);
            RolePermissionType[] userRolePermissions = attributes.get(nodeId).userRolePermissions();
            if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getDeleteNode()))) continue;
            p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        return pending.stream().collect(Collectors.toMap(p -> (DeleteNodesItem)p.value, p -> p.result, (a, b) -> b));
    }

    @Override
    public Map<DeleteReferencesItem, AccessController.AccessResult> checkDeleteReferencesAccess(Session session, List<DeleteReferencesItem> referencesToDelete) {
        DefaultAccessControlContext context = new DefaultAccessControlContext(this.server, session);
        return DefaultAccessController.checkDeleteReferencesAccess(context, referencesToDelete);
    }

    static Map<DeleteReferencesItem, AccessController.AccessResult> checkDeleteReferencesAccess(AccessControlContext context, List<DeleteReferencesItem> referencesToDelete) {
        List pending = referencesToDelete.stream().map(PendingResult::new).toList();
        List<NodeId> nodeIds = referencesToDelete.stream().map(DeleteReferencesItem::getSourceNodeId).toList();
        Map<NodeId, AccessControlAttributes> attributes = context.readAccessControlAttributes(nodeIds);
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, DeleteReferencesItem::getSourceNodeId);
        for (PendingResult p2 : pending) {
            boolean hasAccess;
            if (p2.result.isDenied()) continue;
            NodeId nodeId = ((DeleteReferencesItem)p2.value).getSourceNodeId();
            List roleIds = context.getRoleIds().orElse(null);
            RolePermissionType[] userRolePermissions = attributes.get(nodeId).userRolePermissions();
            if (roleIds == null || userRolePermissions == null || (hasAccess = Stream.of(userRolePermissions).anyMatch(rp -> rp.getPermissions().getRemoveReference()))) continue;
            p2.result = AccessController.AccessResult.DENIED_USER_ACCESS;
        }
        return pending.stream().collect(Collectors.toMap(p -> (DeleteReferencesItem)p.value, p -> p.result, (a, b) -> b));
    }

    private static <T> void checkAccessRestrictions(AccessControlContext context, List<PendingResult<T>> pending, Map<NodeId, AccessControlAttributes> attributes, Function<T, NodeId> getNodeId) {
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, getNodeId, false);
    }

    private static <T> void checkBrowseAccessRestrictions(AccessControlContext context, List<PendingResult<T>> pending, Map<NodeId, AccessControlAttributes> attributes, Function<T, NodeId> getNodeId) {
        DefaultAccessController.checkAccessRestrictions(context, pending, attributes, getNodeId, true);
    }

    private static <T> void checkAccessRestrictions(AccessControlContext context, List<PendingResult<T>> pending, Map<NodeId, AccessControlAttributes> attributes, Function<T, NodeId> getNodeId, boolean browsing) {
        MessageSecurityMode securityMode = context.getSecurityMode();
        for (PendingResult<T> p : pending) {
            NodeId nodeId;
            AccessRestrictionType accessRestrictions;
            if (p.result.isDenied() || (accessRestrictions = attributes.get(nodeId = getNodeId.apply(p.value)).accessRestrictions()) == null || browsing && !accessRestrictions.getApplyRestrictionsToBrowse()) continue;
            if (accessRestrictions.getEncryptionRequired()) {
                if (securityMode == MessageSecurityMode.SignAndEncrypt) continue;
                p.result = AccessController.AccessResult.DENIED_SECURITY_MODE;
                continue;
            }
            if (!accessRestrictions.getSigningRequired() || securityMode == MessageSecurityMode.Sign || securityMode == MessageSecurityMode.SignAndEncrypt) continue;
            p.result = AccessController.AccessResult.DENIED_SECURITY_MODE;
        }
    }

    static class DefaultAccessControlContext
    implements AccessControlContext {
        private final OpcUaServer server;
        private final Session session;

        public DefaultAccessControlContext(OpcUaServer server, Session session) {
            this.server = server;
            this.session = session;
        }

        @Override
        public Optional<List<NodeId>> getRoleIds() {
            return this.session.getRoleIds();
        }

        @Override
        public MessageSecurityMode getSecurityMode() {
            return this.session.getEndpoint().getSecurityMode();
        }

        @Override
        public Map<NodeId, AccessControlAttributes> readAccessControlAttributes(List<NodeId> nodeIds) {
            List<ReadValueId> readValueIds = nodeIds.stream().distinct().flatMap(id -> {
                List<ReadValueId> attributes = List.of(new ReadValueId(id, AttributeId.NodeClass.uid(), null, null), new ReadValueId(id, AttributeId.AccessRestrictions.uid(), null, null), new ReadValueId(id, AttributeId.UserWriteMask.uid(), null, null), new ReadValueId(id, AttributeId.UserAccessLevel.uid(), null, null), new ReadValueId(id, AttributeId.UserExecutable.uid(), null, null), new ReadValueId(id, AttributeId.UserRolePermissions.uid(), null, null));
                return attributes.stream();
            }).toList();
            List<DataValue> values = this.server.getAddressSpaceManager().read(new AddressSpace.ReadContext(this.server, this.session), 0.0, TimestampsToReturn.Neither, readValueIds);
            HashMap<NodeId, AccessControlAttributes> attributesMap = new HashMap<NodeId, AccessControlAttributes>();
            for (int i = 0; i < readValueIds.size(); i += 6) {
                NodeId nodeId = readValueIds.get(i).getNodeId();
                Object v0 = values.get(i).value().value();
                Object v1 = values.get(i + 1).value().value();
                Object v2 = values.get(i + 2).value().value();
                Object v3 = values.get(i + 3).value().value();
                Object v4 = values.get(i + 4).value().value();
                Object v5 = values.get(i + 5).value().value();
                NodeClass nodeClass = null;
                AccessRestrictionType accessRestrictions = null;
                UInteger userWriteMask = null;
                UByte userAccessLevel = null;
                Boolean userExecutable = null;
                RolePermissionType[] userRolePermissions = null;
                if (v0 instanceof NodeClass) {
                    NodeClass nc;
                    nodeClass = nc = (NodeClass)v0;
                }
                if (v1 instanceof AccessRestrictionType) {
                    AccessRestrictionType art;
                    accessRestrictions = art = (AccessRestrictionType)v1;
                }
                if (v2 instanceof UInteger) {
                    UInteger um;
                    userWriteMask = um = (UInteger)v2;
                }
                if (v3 instanceof UByte) {
                    UByte ub;
                    userAccessLevel = ub = (UByte)v3;
                }
                if (v4 instanceof Boolean) {
                    Boolean b;
                    userExecutable = b = (Boolean)v4;
                }
                if (v5 instanceof RolePermissionType[]) {
                    RolePermissionType[] rpt;
                    userRolePermissions = rpt = (RolePermissionType[])v5;
                }
                AccessControlAttributes attributes = new AccessControlAttributes(nodeClass, accessRestrictions, userWriteMask, userAccessLevel, userExecutable, userRolePermissions);
                attributesMap.put(nodeId, attributes);
            }
            return attributesMap;
        }
    }

    static interface AccessControlContext {
        public Optional<List<NodeId>> getRoleIds();

        public MessageSecurityMode getSecurityMode();

        public Map<NodeId, AccessControlAttributes> readAccessControlAttributes(List<NodeId> var1);
    }

    private static class PendingResult<T> {
        private AccessController.AccessResult result = AccessController.AccessResult.ALLOWED;
        private final T value;

        private PendingResult(T value) {
            this.value = value;
        }
    }

    record AccessControlAttributes(@Nullable NodeClass nodeClass, @Nullable AccessRestrictionType accessRestrictions, @Nullable UInteger userWriteMask, @Nullable UByte userAccessLevel, @Nullable Boolean userExecutable, RolePermissionType @Nullable [] userRolePermissions) {
    }
}

