/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class BrowsePath {
    static final BrowsePath ROOT = new BrowsePath(null, new QualifiedName(0, "/"));
    final BrowsePath parent;
    final QualifiedName browseName;

    BrowsePath(BrowsePath parent, QualifiedName browseName) {
        this.parent = parent;
        this.browseName = browseName;
    }

    public String join() {
        return this.join("/", true);
    }

    public String join(String separator, boolean includeNamespaceIndex) {
        if (this.parent == null) {
            return "";
        }
        Object s = this.parent.join(separator, includeNamespaceIndex);
        if (!((String)s).endsWith(separator)) {
            s = (String)s + separator;
        }
        if (includeNamespaceIndex) {
            s = (String)s + String.valueOf(this.browseName.namespaceIndex()) + ":";
        }
        return (String)s + this.browseName.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowsePath that = (BrowsePath)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.browseName, that.browseName);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.browseName);
    }

    public String toString() {
        return this.join();
    }
}

