/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableTypeNodeProperties;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.shaded.com.google.common.base.Preconditions;
import org.jspecify.annotations.Nullable;

public class UaVariableTypeNode
extends UaNode
implements VariableTypeNode {
    private DataValue value;
    private NodeId dataType;
    private Integer valueRank;
    private UInteger[] arrayDimensions;
    private Boolean isAbstract;

    public UaVariableTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, Boolean isAbstract) {
        super(context, nodeId, NodeClass.VariableType, browseName, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    public UaVariableTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, Boolean isAbstract) {
        super(context, nodeId, NodeClass.VariableType, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    public DataValue getValue() {
        return (DataValue)this.filterChain.getAttribute(this, AttributeId.Value);
    }

    public NodeId getDataType() {
        return (NodeId)this.filterChain.getAttribute(this, AttributeId.DataType);
    }

    public Integer getValueRank() {
        return (Integer)this.filterChain.getAttribute(this, AttributeId.ValueRank);
    }

    public UInteger[] getArrayDimensions() {
        return (UInteger[])this.filterChain.getAttribute(this, AttributeId.ArrayDimensions);
    }

    public Boolean getIsAbstract() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.IsAbstract);
    }

    public void setValue(DataValue value) {
        this.filterChain.setAttribute(this, AttributeId.Value, value);
    }

    public void setDataType(NodeId dataType) {
        this.filterChain.setAttribute(this, AttributeId.DataType, dataType);
    }

    public void setValueRank(Integer valueRank) {
        this.filterChain.setAttribute(this, AttributeId.ValueRank, valueRank);
    }

    public void setArrayDimensions(UInteger[] arrayDimensions) {
        this.filterChain.setAttribute(this, AttributeId.ArrayDimensions, arrayDimensions);
    }

    public void setIsAbstract(Boolean isAbstract) {
        this.filterChain.setAttribute(this, AttributeId.IsAbstract, isAbstract);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.Value -> this.value;
            case AttributeId.DataType -> this.dataType;
            case AttributeId.ValueRank -> this.valueRank;
            case AttributeId.ArrayDimensions -> this.arrayDimensions;
            case AttributeId.IsAbstract -> this.isAbstract;
            default -> super.getAttribute(attributeId);
        };
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case Value: {
                this.value = (DataValue)value;
                break;
            }
            case DataType: {
                this.dataType = (NodeId)value;
                break;
            }
            case ValueRank: {
                this.valueRank = (Integer)value;
                break;
            }
            case ArrayDimensions: {
                this.arrayDimensions = (UInteger[])value;
                break;
            }
            case IsAbstract: {
                this.isAbstract = (Boolean)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public @Nullable String getNodeVersion() {
        return this.getProperty(VariableTypeNodeProperties.NodeVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(VariableTypeNodeProperties.NodeVersion, nodeVersion);
    }

    public static UaVariableTypeNodeBuilder builder(UaNodeContext context) {
        return new UaVariableTypeNodeBuilder(context);
    }

    public static UaVariableTypeNode build(UaNodeContext context, Function<UaVariableTypeNodeBuilder, UaVariableTypeNode> build) {
        UaVariableTypeNodeBuilder builder = new UaVariableTypeNodeBuilder(context);
        return build.apply(builder);
    }

    public static class UaVariableTypeNodeBuilder
    implements Supplier<UaVariableTypeNode> {
        private final List<AttributeFilter> attributeFilters = new ArrayList<AttributeFilter>();
        private final List<Reference> references = new ArrayList<Reference>();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private RolePermissionType[] rolePermissions;
        private RolePermissionType[] userRolePermissions;
        private AccessRestrictionType accessRestrictions;
        private DataValue value = new DataValue(Variant.NULL_VALUE);
        private NodeId dataType = NodeIds.BaseDataType;
        private Integer valueRank = -1;
        private UInteger[] arrayDimensions = null;
        private Boolean isAbstract = false;
        private final UaNodeContext context;

        public UaVariableTypeNodeBuilder(UaNodeContext context) {
            this.context = context;
        }

        @Override
        public UaVariableTypeNode get() {
            return this.build();
        }

        public UaVariableTypeNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            UaVariableTypeNode node = new UaVariableTypeNode(this.context, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.rolePermissions, this.userRolePermissions, this.accessRestrictions, this.value, this.dataType, this.valueRank, this.arrayDimensions, this.isAbstract);
            this.references.forEach(node::addReference);
            node.getFilterChain().addLast(this.attributeFilters);
            return node;
        }

        public UaVariableTypeNode buildAndAdd() {
            UaVariableTypeNode node = this.build();
            this.context.getNodeManager().addNode(node);
            return node;
        }

        public UaVariableTypeNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaVariableTypeNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaVariableTypeNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaVariableTypeNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaVariableTypeNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaVariableTypeNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaVariableTypeNodeBuilder setRolePermissions(RolePermissionType[] rolePermissions) {
            this.rolePermissions = rolePermissions;
            return this;
        }

        public UaVariableTypeNodeBuilder setUserRolePermissions(RolePermissionType[] userRolePermissions) {
            this.userRolePermissions = userRolePermissions;
            return this;
        }

        public UaVariableTypeNodeBuilder setAccessRestrictions(AccessRestrictionType accessRestrictions) {
            this.accessRestrictions = accessRestrictions;
            return this;
        }

        public UaVariableTypeNodeBuilder setValue(DataValue value) {
            this.value = value;
            return this;
        }

        public UaVariableTypeNodeBuilder setDataType(NodeId dataType) {
            this.dataType = dataType;
            return this;
        }

        public UaVariableTypeNodeBuilder setValueRank(Integer valueRank) {
            this.valueRank = valueRank;
            return this;
        }

        public UaVariableTypeNodeBuilder setArrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return this;
        }

        public UaVariableTypeNodeBuilder setIsAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public QualifiedName getBrowseName() {
            return this.browseName;
        }

        public LocalizedText getDisplayName() {
            return this.displayName;
        }

        public LocalizedText getDescription() {
            return this.description;
        }

        public UInteger getWriteMask() {
            return this.writeMask;
        }

        public UInteger getUserWriteMask() {
            return this.userWriteMask;
        }

        public RolePermissionType[] getRolePermissions() {
            return this.rolePermissions;
        }

        public RolePermissionType[] getUserRolePermissions() {
            return this.userRolePermissions;
        }

        public AccessRestrictionType getAccessRestrictions() {
            return this.accessRestrictions;
        }

        public DataValue getValue() {
            return this.value;
        }

        public NodeId getDataType() {
            return this.dataType;
        }

        public Integer getValueRank() {
            return this.valueRank;
        }

        public UInteger[] getArrayDimensions() {
            return this.arrayDimensions;
        }

        public Boolean getIsAbstract() {
            return this.isAbstract;
        }

        public UaVariableTypeNodeBuilder addAttributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilters.add(attributeFilter);
            return this;
        }

        public UaVariableTypeNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }
    }
}

