/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.BuildInfoTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.ServerStatusType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ServerStatusTypeNode
extends BaseDataVariableTypeNode
implements ServerStatusType {
    public ServerStatusTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing, AccessLevelExType accessLevelEx) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing, accessLevelEx);
    }

    public ServerStatusTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, value, dataType, valueRank, arrayDimensions);
    }

    @Override
    public BaseDataVariableTypeNode getStartTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime");
        return component.orElse(null);
    }

    @Override
    public DateTime getStartTime() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setStartTime(DateTime value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentTimeNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentTime");
        return component.orElse(null);
    }

    @Override
    public DateTime getCurrentTime() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentTime");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setCurrentTime(DateTime value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentTime").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "State");
        return component.orElse(null);
    }

    @Override
    public ServerState getState() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "State");
        return component.map(node -> (ServerState)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setState(ServerState value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "State").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BuildInfoTypeNode getBuildInfoNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "BuildInfo");
        return component.orElse(null);
    }

    @Override
    public BuildInfo getBuildInfo() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "BuildInfo");
        return component.map(node -> (BuildInfo)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setBuildInfo(BuildInfo value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "BuildInfo").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getSecondsTillShutdownNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SecondsTillShutdown");
        return component.orElse(null);
    }

    @Override
    public UInteger getSecondsTillShutdown() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SecondsTillShutdown");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setSecondsTillShutdown(UInteger value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "SecondsTillShutdown").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public BaseDataVariableTypeNode getShutdownReasonNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ShutdownReason");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getShutdownReason() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ShutdownReason");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setShutdownReason(LocalizedText value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "ShutdownReason").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

