/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.model.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.server.model.variables.TwoStateVariableType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface AcknowledgeableConditionType
extends ConditionType {
    @Override
    public TwoStateVariableType getEnabledStateNode();

    @Override
    public LocalizedText getEnabledState();

    @Override
    public void setEnabledState(LocalizedText var1);

    public TwoStateVariableType getAckedStateNode();

    public LocalizedText getAckedState();

    public void setAckedState(LocalizedText var1);

    public TwoStateVariableType getConfirmedStateNode();

    public LocalizedText getConfirmedState();

    public void setConfirmedState(LocalizedText var1);

    public MethodNode getAcknowledgeMethodNode();

    public MethodNode getConfirmMethodNode();

    public static abstract class ConfirmMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public ConfirmMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("EventId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The identifier for the event to comment.")), new Argument("Comment", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The comment to add to the condition."))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ByteString eventId = (ByteString)inputValues[0].getValue();
            LocalizedText comment = (LocalizedText)inputValues[1].getValue();
            this.invoke(context, eventId, comment);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ByteString var2, LocalizedText var3) throws UaException;
    }

    public static abstract class AcknowledgeMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AcknowledgeMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("EventId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The identifier for the event to comment.")), new Argument("Comment", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The comment to add to the condition."))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ByteString eventId = (ByteString)inputValues[0].getValue();
            LocalizedText comment = (LocalizedText)inputValues[1].getValue();
            this.invoke(context, eventId, comment);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ByteString var2, LocalizedText var3) throws UaException;
    }
}

