/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.methods;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.typetree.DataType;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.methods.InvalidArgumentException;
import org.eclipse.milo.opcua.sdk.server.methods.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.Matrix;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;

public abstract class AbstractMethodInvocationHandler
implements MethodInvocationHandler {
    private final UaMethodNode node;

    public AbstractMethodInvocationHandler(UaMethodNode node) {
        this.node = node;
    }

    public UaMethodNode getNode() {
        return this.node;
    }

    @Override
    public final CallMethodResult invoke(final AccessContext accessContext, final CallMethodRequest request) {
        try {
            Variant[] inputArgumentValues = Objects.requireNonNullElse(request.getInputArguments(), new Variant[0]);
            if (inputArgumentValues.length < this.getInputArguments().length) {
                throw new UaException(2155216896L);
            }
            if (inputArgumentValues.length > this.getInputArguments().length) {
                throw new UaException(2162491392L);
            }
            StatusCode[] inputDataTypeCheckResults = new StatusCode[inputArgumentValues.length];
            for (int i = 0; i < inputArgumentValues.length; ++i) {
                int valueRank;
                NodeId valueDataTypeId;
                NodeId argDataTypeId;
                Argument argument = this.getInputArguments()[i];
                Variant variant = inputArgumentValues[i];
                Object value = variant.value();
                boolean dataTypeMatch = true;
                if (value != null && !(argDataTypeId = argument.getDataType()).equals((Object)(valueDataTypeId = variant.getDataTypeId().flatMap(xni -> xni.toNodeId(this.node.getNodeContext().getNamespaceTable())).orElse(NodeId.NULL_VALUE)))) {
                    DataTypeTree dataTypeTree = this.node.getNodeContext().getServer().getDataTypeTree();
                    if (dataTypeTree.isStructType(argDataTypeId)) {
                        boolean isAbstract;
                        ExtensionObject xo = (ExtensionObject)value;
                        UaStructuredType decoded = xo.decode(this.node.getNodeContext().getServer().getStaticEncodingContext());
                        valueDataTypeId = decoded.getTypeId().toNodeId(this.node.getNodeContext().getNamespaceTable()).orElse(NodeId.NULL_VALUE);
                        DataType argType = (DataType)dataTypeTree.getType(argDataTypeId);
                        boolean bl = isAbstract = argType != null && argType.isAbstract() != false;
                        dataTypeMatch = isAbstract ? dataTypeTree.isSubtypeOf(valueDataTypeId, argDataTypeId) : Objects.equals(valueDataTypeId, argDataTypeId);
                    } else {
                        dataTypeMatch = dataTypeTree.isAssignable(argDataTypeId, value.getClass());
                    }
                }
                if ((valueRank = argument.getValueRank().intValue()) == -1) {
                    if (value != null && (value.getClass().isArray() || value instanceof Matrix)) {
                        dataTypeMatch = false;
                    }
                } else if (valueRank == 1) {
                    if (value != null && !value.getClass().isArray()) {
                        dataTypeMatch = false;
                    }
                } else if (valueRank == 0) {
                    if (value != null && !value.getClass().isArray() && !(value instanceof Matrix)) {
                        dataTypeMatch = false;
                    }
                } else if (valueRank > 1 && value != null && !(value instanceof Matrix)) {
                    dataTypeMatch = false;
                }
                inputDataTypeCheckResults[i] = dataTypeMatch ? StatusCode.GOOD : new StatusCode(2155085824L);
            }
            if (Arrays.stream(inputDataTypeCheckResults).anyMatch(StatusCode::isBad)) {
                throw new InvalidArgumentException(inputDataTypeCheckResults);
            }
            this.validateInputArgumentValues(inputArgumentValues);
            InvocationContext invocationContext = new InvocationContext(){

                @Override
                public OpcUaServer getServer() {
                    return AbstractMethodInvocationHandler.this.node.getNodeContext().getServer();
                }

                @Override
                public NodeId getObjectId() {
                    return request.getObjectId();
                }

                @Override
                public UaMethodNode getMethodNode() {
                    return AbstractMethodInvocationHandler.this.node;
                }

                @Override
                public Optional<Session> getSession() {
                    return accessContext.getSession();
                }
            };
            Variant[] outputValues = this.invoke(invocationContext, inputArgumentValues);
            return new CallMethodResult(StatusCode.GOOD, new StatusCode[0], new DiagnosticInfo[0], outputValues);
        }
        catch (InvalidArgumentException e) {
            return new CallMethodResult(e.getStatusCode(), e.getInputArgumentResults(), e.getInputArgumentDiagnosticInfos(), new Variant[0]);
        }
        catch (UaException e) {
            return new CallMethodResult(e.getStatusCode(), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]);
        }
    }

    public abstract Argument[] getInputArguments();

    public abstract Argument[] getOutputArguments();

    protected abstract Variant[] invoke(InvocationContext var1, Variant[] var2) throws UaException;

    protected void validateInputArgumentValues(Variant[] inputArgumentValues) throws InvalidArgumentException {
    }

    public static interface InvocationContext
    extends AccessContext {
        public OpcUaServer getServer();

        public NodeId getObjectId();

        public UaMethodNode getMethodNode();
    }
}

