/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.Identity;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.IssuedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;

public abstract class AbstractIdentityValidator
implements IdentityValidator {
    @Override
    public Identity validateIdentityToken(Session session, UserIdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        return switch (policy.getTokenType()) {
            default -> throw new IncompatibleClassChangeError();
            case UserTokenType.Anonymous -> {
                if (token instanceof AnonymousIdentityToken) {
                    yield this.validateAnonymousToken(session, (AnonymousIdentityToken)token, policy, signature);
                }
                throw new UaException(0x80200000L);
            }
            case UserTokenType.UserName -> {
                if (token instanceof UserNameIdentityToken) {
                    yield this.validateUsernameToken(session, (UserNameIdentityToken)token, policy, signature);
                }
                throw new UaException(0x80200000L);
            }
            case UserTokenType.Certificate -> {
                if (token instanceof X509IdentityToken) {
                    yield this.validateX509Token(session, (X509IdentityToken)token, policy, signature);
                }
                throw new UaException(0x80200000L);
            }
            case UserTokenType.IssuedToken -> {
                if (token instanceof IssuedIdentityToken) {
                    yield this.validateIssuedIdentityToken(session, (IssuedIdentityToken)token, policy, signature);
                }
                throw new UaException(0x80200000L);
            }
        };
    }

    protected Identity.AnonymousIdentity validateAnonymousToken(Session session, AnonymousIdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Identity.UsernameIdentity validateUsernameToken(Session session, UserNameIdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Identity.X509UserIdentity validateX509Token(Session session, X509IdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Identity.IssuedIdentity validateIssuedIdentityToken(Session session, IssuedIdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected byte[] decryptTokenData(Session session, SecurityAlgorithm algorithm, byte[] dataBytes) throws UaException {
        X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])session.getEndpoint().getServerCertificate().bytesOrEmpty());
        int cipherTextBlockSize = SecureChannel.getAsymmetricCipherTextBlockSize((Certificate)certificate, (SecurityAlgorithm)algorithm);
        int blockCount = dataBytes.length / cipherTextBlockSize;
        int plainTextBufferSize = cipherTextBlockSize * blockCount;
        byte[] plainTextBytes = new byte[plainTextBufferSize];
        ByteBuffer plainTextNioBuffer = ByteBuffer.wrap(plainTextBytes);
        ByteBuffer passwordNioBuffer = ByteBuffer.wrap(dataBytes);
        try {
            KeyPair keyPair = (KeyPair)session.getServer().getConfig().getCertificateManager().getKeyPair(ByteString.of((byte[])DigestUtil.sha1((byte[])certificate.getEncoded()))).orElseThrow(() -> new UaException(2148728832L));
            Cipher cipher = this.getCipher(algorithm, keyPair);
            for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
                ((Buffer)passwordNioBuffer).limit(passwordNioBuffer.position() + cipherTextBlockSize);
                cipher.doFinal(passwordNioBuffer, plainTextNioBuffer);
            }
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
        return plainTextBytes;
    }

    private Cipher getCipher(SecurityAlgorithm algorithm, KeyPair keyPair) throws UaException {
        try {
            String transformation = algorithm.getTransformation();
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, keyPair.getPrivate());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }
}

