/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class SByteConversions {
    private SByteConversions() {
    }

    static @NonNull Boolean sByteToBoolean(@NonNull Byte b) {
        return b != 0;
    }

    static @Nullable UByte sByteToByte(@NonNull Byte b) {
        if (b >= 0) {
            return Unsigned.ubyte((byte)b);
        }
        return null;
    }

    static @NonNull Double sByteToDouble(@NonNull Byte b) {
        return b.doubleValue();
    }

    static @NonNull Float sByteToFloat(@NonNull Byte b) {
        return Float.valueOf(b.floatValue());
    }

    static @NonNull Short sByteToInt16(@NonNull Byte b) {
        return b.shortValue();
    }

    static @NonNull Integer sByteToInt32(@NonNull Byte b) {
        return b.intValue();
    }

    static @NonNull Long sByteToInt64(@NonNull Byte b) {
        return b.longValue();
    }

    static @NonNull String sByteToString(@NonNull Byte b) {
        return b.toString();
    }

    static @Nullable UShort sByteToUInt16(@NonNull Byte b) {
        if (b >= 0) {
            return Unsigned.ushort((short)b.byteValue());
        }
        return null;
    }

    static @Nullable UInteger sByteToUInt32(@NonNull Byte b) {
        if (b >= 0) {
            return Unsigned.uint((int)b.byteValue());
        }
        return null;
    }

    static @Nullable ULong sByteToUInt64(@NonNull Byte b) {
        if (b >= 0) {
            return Unsigned.ulong((long)b.byteValue());
        }
        return null;
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Byte) {
            Byte b = (Byte)o;
            return implicit ? SByteConversions.implicitConversion(b, targetType) : SByteConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Byte b, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return SByteConversions.sByteToBoolean(b);
            }
            case Byte: {
                return SByteConversions.sByteToByte(b);
            }
            case String: {
                return SByteConversions.sByteToString(b);
            }
        }
        return SByteConversions.implicitConversion(b, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Byte b, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return SByteConversions.sByteToDouble(b);
            }
            case Float: {
                return SByteConversions.sByteToFloat(b);
            }
            case Int16: {
                return SByteConversions.sByteToInt16(b);
            }
            case Int32: {
                return SByteConversions.sByteToInt32(b);
            }
            case Int64: {
                return SByteConversions.sByteToInt64(b);
            }
            case UInt16: {
                return SByteConversions.sByteToUInt16(b);
            }
            case UInt32: {
                return SByteConversions.sByteToUInt32(b);
            }
            case UInt64: {
                return SByteConversions.sByteToUInt64(b);
            }
        }
        return null;
    }
}

