/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class QualifiedNameConversions {
    private QualifiedNameConversions() {
    }

    static @Nullable String qualifiedNameToString(@NonNull QualifiedName name) {
        return name.name();
    }

    static @NonNull LocalizedText qualifiedNameToLocalizedText(@NonNull QualifiedName name) {
        return new LocalizedText("", name.name());
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)o;
            return implicit ? QualifiedNameConversions.implicitConversion(name, targetType) : QualifiedNameConversions.explicitConversion(name, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull QualifiedName name, OpcUaDataType targetType) {
        return QualifiedNameConversions.implicitConversion(name, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull QualifiedName name, OpcUaDataType targetType) {
        switch (targetType) {
            case String: {
                return QualifiedNameConversions.qualifiedNameToString(name);
            }
            case LocalizedText: {
                return QualifiedNameConversions.qualifiedNameToLocalizedText(name);
            }
        }
        return null;
    }
}

