/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class Int64Conversions {
    private Int64Conversions() {
    }

    static @NonNull Boolean int64ToBoolean(@NonNull Long l) {
        return l != 0L;
    }

    static @Nullable UByte int64ToByte(@NonNull Long l) {
        if (l >= 0L && l <= 255L) {
            return Unsigned.ubyte((long)l);
        }
        return null;
    }

    static @NonNull Double int64ToDouble(@NonNull Long l) {
        return l.doubleValue();
    }

    static @NonNull Float int64ToFloat(@NonNull Long l) {
        return Float.valueOf(l.floatValue());
    }

    static @Nullable Short int64ToInt16(@NonNull Long l) {
        if (l >= -32768L && l <= 32767L) {
            return l.shortValue();
        }
        return null;
    }

    static @Nullable Integer int64ToInt32(@NonNull Long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return l.intValue();
        }
        return null;
    }

    static @Nullable Byte int64ToSByte(@NonNull Long l) {
        if (l >= -128L && l <= 127L) {
            return l.byteValue();
        }
        return null;
    }

    static @NonNull StatusCode int64ToStatusCode(@NonNull Long l) {
        return new StatusCode(l.longValue());
    }

    static @NonNull String int64ToString(@NonNull Long l) {
        return l.toString();
    }

    static @Nullable UShort int64ToUInt16(@NonNull Long l) {
        if (l >= 0L && l <= 65535L) {
            return Unsigned.ushort((int)l.intValue());
        }
        return null;
    }

    static @Nullable UInteger int64ToUInt32(@NonNull Long l) {
        if (l >= 0L && l <= 0xFFFFFFFFL) {
            return Unsigned.uint((long)l);
        }
        return null;
    }

    static @Nullable ULong int64ToUInt64(@NonNull Long l) {
        if (l >= 0L) {
            return Unsigned.ulong((long)l);
        }
        return null;
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Long) {
            Long l = (Long)o;
            return implicit ? Int64Conversions.implicitConversion(l, targetType) : Int64Conversions.explicitConversion(l, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Long l, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int64Conversions.int64ToBoolean(l);
            }
            case Byte: {
                return Int64Conversions.int64ToByte(l);
            }
            case Int16: {
                return Int64Conversions.int64ToInt16(l);
            }
            case Int32: {
                return Int64Conversions.int64ToInt32(l);
            }
            case SByte: {
                return Int64Conversions.int64ToSByte(l);
            }
            case StatusCode: {
                return Int64Conversions.int64ToStatusCode(l);
            }
            case String: {
                return Int64Conversions.int64ToString(l);
            }
            case UInt16: {
                return Int64Conversions.int64ToUInt16(l);
            }
            case UInt32: {
                return Int64Conversions.int64ToUInt32(l);
            }
            case UInt64: {
                return Int64Conversions.int64ToUInt64(l);
            }
        }
        return Int64Conversions.implicitConversion(l, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Long l, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int64Conversions.int64ToDouble(l);
            }
            case Float: {
                return Int64Conversions.int64ToFloat(l);
            }
        }
        return null;
    }
}

