/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class Int16Conversions {
    private Int16Conversions() {
    }

    static @NonNull Boolean int16ToBoolean(@NonNull Short s) {
        return s != 0;
    }

    static @Nullable UByte int16ToByte(@NonNull Short s) {
        if (s >= 0 && s <= 255) {
            return Unsigned.ubyte((short)s);
        }
        return null;
    }

    static @NonNull Double int16ToDouble(@NonNull Short s) {
        return (double)s;
    }

    static @NonNull Float int16ToFloat(@NonNull Short s) {
        return Float.valueOf(s.shortValue());
    }

    static @NonNull Integer int16ToInt32(@NonNull Short s) {
        return (int)s;
    }

    static @NonNull Long int16ToInt64(@NonNull Short s) {
        return (long)s;
    }

    static @Nullable Byte int16ToSByte(@NonNull Short s) {
        if (s >= -128 && s <= 127) {
            return s.byteValue();
        }
        return null;
    }

    static @NonNull String int16ToString(@NonNull Short s) {
        return s.toString();
    }

    static @Nullable UShort int16ToUInt16(@NonNull Short s) {
        if (s >= 0) {
            return Unsigned.ushort((short)s);
        }
        return null;
    }

    static @Nullable UInteger int16ToUInt32(@NonNull Short s) {
        if (s >= 0) {
            return Unsigned.uint((int)s.shortValue());
        }
        return null;
    }

    static @Nullable ULong int16ToUInt64(@NonNull Short s) {
        if (s >= 0) {
            return Unsigned.ulong((long)s.shortValue());
        }
        return null;
    }

    static @Nullable Object convert(@Nullable Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof Short) {
            Short s = (Short)o;
            return implicit ? Int16Conversions.implicitConversion(s, targetType) : Int16Conversions.explicitConversion(s, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull Short s, OpcUaDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int16Conversions.int16ToBoolean(s);
            }
            case Byte: {
                return Int16Conversions.int16ToByte(s);
            }
            case SByte: {
                return Int16Conversions.int16ToSByte(s);
            }
            case String: {
                return Int16Conversions.int16ToString(s);
            }
            case UInt16: {
                return Int16Conversions.int16ToUInt16(s);
            }
        }
        return Int16Conversions.implicitConversion(s, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull Short s, OpcUaDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int16Conversions.int16ToDouble(s);
            }
            case Float: {
                return Int16Conversions.int16ToFloat(s);
            }
            case Int32: {
                return Int16Conversions.int16ToInt32(s);
            }
            case Int64: {
                return Int16Conversions.int16ToInt64(s);
            }
            case UInt32: {
                return Int16Conversions.int16ToUInt32(s);
            }
            case UInt64: {
                return Int16Conversions.int16ToUInt64(s);
            }
        }
        return null;
    }
}

