/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceTypeTree;
import org.eclipse.milo.opcua.sdk.server.AccessContext;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.AttributeReader;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.events.FilterContext;
import org.eclipse.milo.opcua.sdk.server.events.OperatorContext;
import org.eclipse.milo.opcua.sdk.server.events.ValidationException;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operator;
import org.eclipse.milo.opcua.sdk.server.events.operators.Operators;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.FilterOperator;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AttributeOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElement;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElementResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ElementOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.LiteralOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventContentFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventContentFilter.class);

    public static EventFilterResult validate(FilterContext context, EventFilter filter) throws UaException {
        SimpleAttributeOperand[] selectClauses = filter.getSelectClauses();
        if (selectClauses == null || selectClauses.length == 0) {
            throw new UaException(2152136704L);
        }
        SelectClauseValidationResult selectClauseResults = EventContentFilter.validateSelectClauses(context, selectClauses);
        ContentFilterResult whereClauseResult = EventContentFilter.validateWhereClause(context, filter.getWhereClause());
        return new EventFilterResult(selectClauseResults.statusCodes, selectClauseResults.diagnosticInfos, whereClauseResult);
    }

    private static SelectClauseValidationResult validateSelectClauses(FilterContext context, SimpleAttributeOperand[] selectClauses) {
        ArrayList<StatusCode> statusCodes = new ArrayList<StatusCode>();
        ArrayList<DiagnosticInfo> diagnosticInfos = new ArrayList<DiagnosticInfo>();
        for (SimpleAttributeOperand select : selectClauses) {
            try {
                EventContentFilter.validateSimpleOperand(context, select);
                statusCodes.add(StatusCode.GOOD);
                diagnosticInfos.add(DiagnosticInfo.NULL_VALUE);
            }
            catch (ValidationException e) {
                statusCodes.add(e.getStatusCode());
                diagnosticInfos.add(e.getDiagnosticInfo());
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected error validating operand: {}", (Object)select, (Object)t);
                statusCodes.add(new StatusCode(0x80020000L));
                diagnosticInfos.add(DiagnosticInfo.NULL_VALUE);
            }
        }
        return new SelectClauseValidationResult(statusCodes.toArray(new StatusCode[0]), diagnosticInfos.toArray(new DiagnosticInfo[0]));
    }

    private static void validateSimpleOperand(FilterContext context, SimpleAttributeOperand select) throws ValidationException {
        NodeId eventTypeId = select.getTypeDefinitionId();
        if (eventTypeId != null && !eventTypeId.equals((Object)NodeIds.BaseEventType)) {
            UaNode node = context.getServer().getAddressSpaceManager().getManagedNode(eventTypeId).orElse(null);
            if (node == null || node.getNodeClass() != NodeClass.ObjectType) {
                throw new ValidationException(2153971712L);
            }
            QualifiedName[] browsePath = select.getBrowsePath();
            if (browsePath == null || Arrays.stream(browsePath).anyMatch(Objects::isNull)) {
                throw new ValidationException(0x80600000L);
            }
            Node relativeNode = EventContentFilter.getRelativeNode(context, node, browsePath);
            if (relativeNode == null) {
                throw new ValidationException(2150891520L);
            }
            UInteger attributeId = select.getAttributeId();
            Set validAttributes = AttributeId.getAttributes((NodeClass)relativeNode.getNodeClass());
            boolean validAttribute = AttributeId.from((UInteger)attributeId).map(validAttributes::contains).orElse(false);
            if (!validAttribute) {
                throw new ValidationException(2150957056L);
            }
            String indexRange = select.getIndexRange();
            if (indexRange != null && !indexRange.isEmpty()) {
                if (relativeNode instanceof VariableNode) {
                    int valueRank = ((VariableNode)relativeNode).getValueRank();
                    if (valueRank == -1) {
                        throw new ValidationException(2151022592L);
                    }
                } else {
                    throw new ValidationException(2151022592L);
                }
            }
        }
    }

    private static @Nullable Node getRelativeNode(FilterContext context, @NonNull UaNode startingNode, @NonNull QualifiedName[] browsePath) {
        QualifiedName targetBrowsePath;
        UaNode relativeNode = startingNode;
        Predicate<UaNode> nodePredicate = n -> n.getNodeClass() == NodeClass.Object || n.getNodeClass() == NodeClass.Variable;
        ReferenceTypeTree referenceTypeTree = startingNode.getNodeContext().getServer().getReferenceTypeTree();
        Predicate<Reference> referencePredicate = r -> r.isForward() && referenceTypeTree.isSubtypeOf(r.getReferenceTypeId(), NodeIds.HierarchicalReferences);
        QualifiedName[] qualifiedNameArray = browsePath;
        int n2 = qualifiedNameArray.length;
        for (int i = 0; i < n2 && (relativeNode = (UaNode)relativeNode.findNode(targetBrowsePath = qualifiedNameArray[i], nodePredicate, referencePredicate).orElse(null)) != null; ++i) {
        }
        return relativeNode;
    }

    private static ContentFilterResult validateWhereClause(FilterContext context, ContentFilter whereClause) {
        ContentFilterElement[] filterElements = whereClause.getElements();
        if (filterElements == null) {
            return new ContentFilterResult(new ContentFilterElementResult[0], new DiagnosticInfo[0]);
        }
        ContentFilterElementResult[] elementResults = (ContentFilterElementResult[])Arrays.stream(filterElements).map(e -> EventContentFilter.validateFilterElement(context, e)).toArray(ContentFilterElementResult[]::new);
        return new ContentFilterResult(elementResults, new DiagnosticInfo[0]);
    }

    private static ContentFilterElementResult validateFilterElement(@NonNull FilterContext context, @NonNull ContentFilterElement filterElement) {
        FilterOperator filterOperator = filterElement.getFilterOperator();
        if (!Operators.SUPPORTED_OPERATORS.contains(filterOperator)) {
            return new ContentFilterElementResult(new StatusCode(2160197632L), new StatusCode[0], new DiagnosticInfo[0]);
        }
        ExtensionObject[] xos = filterElement.getFilterOperands();
        if (xos == null || xos.length == 0) {
            return new ContentFilterElementResult(new StatusCode(2160263168L), new StatusCode[0], new DiagnosticInfo[0]);
        }
        FilterOperand[] operands = new FilterOperand[xos.length];
        StatusCode[] operandStatusCodes = new StatusCode[xos.length];
        for (int i = 0; i < xos.length; ++i) {
            UaStructuredType operand;
            try {
                operand = xos[i].decode(context.getServer().getStaticEncodingContext());
            }
            catch (Exception ignored) {
                operand = null;
            }
            if (operand instanceof FilterOperand) {
                operands[i] = (FilterOperand)operand;
                if (operand instanceof SimpleAttributeOperand) {
                    try {
                        EventContentFilter.validateSimpleOperand(context, (SimpleAttributeOperand)operand);
                        operandStatusCodes[i] = StatusCode.GOOD;
                    }
                    catch (ValidationException e) {
                        operandStatusCodes[i] = e.getStatusCode();
                    }
                    continue;
                }
                if (operand instanceof ElementOperand) {
                    operandStatusCodes[i] = StatusCode.GOOD;
                    continue;
                }
                if (operand instanceof LiteralOperand) {
                    operandStatusCodes[i] = StatusCode.GOOD;
                    continue;
                }
                operandStatusCodes[i] = new StatusCode(2152267776L);
                continue;
            }
            operandStatusCodes[i] = new StatusCode(2152267776L);
        }
        StatusCode operatorStatus = StatusCode.GOOD;
        try {
            Operator<?> operator = EventContentFilter.getOperator(filterOperator);
            operator.validate(context, operands);
        }
        catch (ValidationException e) {
            operatorStatus = e.getStatusCode();
        }
        return new ContentFilterElementResult(operatorStatus, operandStatusCodes, new DiagnosticInfo[0]);
    }

    public static Variant[] select(@NonNull FilterContext context, @NonNull SimpleAttributeOperand[] selectClauses, @NonNull BaseEventTypeNode eventNode) {
        return (Variant[])Arrays.stream(selectClauses).map(operand -> {
            try {
                return new Variant(EventContentFilter.getSimpleAttribute(context, operand, eventNode));
            }
            catch (UaException e) {
                return Variant.NULL_VALUE;
            }
        }).toArray(Variant[]::new);
    }

    public static boolean evaluate(@NonNull FilterContext context, @NonNull ContentFilter whereClause, @NonNull BaseEventTypeNode eventNode) throws UaException {
        if (whereClause.getElements() == null || whereClause.getElements().length == 0) {
            return true;
        }
        ContentFilterElement[] elements = whereClause.getElements();
        DefaultOperatorContext operatorContext = new DefaultOperatorContext(context, elements);
        Object result = EventContentFilter.evaluate(operatorContext, eventNode, elements[0]);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new UaException(0x80480000L);
    }

    private static @Nullable Object evaluate(@NonNull OperatorContext context, @NonNull BaseEventTypeNode eventNode, @NonNull ContentFilterElement element) throws UaException {
        FilterOperator filterOperator = element.getFilterOperator();
        if (filterOperator == null) {
            throw new UaException(2160132096L);
        }
        FilterOperand[] filterOperands = EventContentFilter.decodeOperands(context.getServer().getStaticEncodingContext(), element.getFilterOperands());
        Operator<?> operator = EventContentFilter.getOperator(filterOperator);
        return operator.apply(context, eventNode, filterOperands);
    }

    private static @NonNull FilterOperand[] decodeOperands(EncodingContext context, ExtensionObject @Nullable [] operandXos) {
        if (operandXos == null) {
            return new FilterOperand[0];
        }
        return (FilterOperand[])Arrays.stream(operandXos).map(xo -> (FilterOperand)xo.decode(context)).toArray(FilterOperand[]::new);
    }

    private static @NonNull Operator<?> getOperator(@NonNull FilterOperator filterOperator) {
        return switch (filterOperator) {
            default -> throw new IncompatibleClassChangeError();
            case FilterOperator.Equals -> Operators.EQUALS;
            case FilterOperator.IsNull -> Operators.IS_NULL;
            case FilterOperator.GreaterThan -> Operators.GREATER_THAN;
            case FilterOperator.LessThan -> Operators.LESS_THAN;
            case FilterOperator.GreaterThanOrEqual -> Operators.GREATER_THAN_OR_EQUAL;
            case FilterOperator.LessThanOrEqual -> Operators.LESS_THAN_OR_EQUAL;
            case FilterOperator.Like -> Operators.UNSUPPORTED;
            case FilterOperator.Not -> Operators.NOT;
            case FilterOperator.Between -> Operators.UNSUPPORTED;
            case FilterOperator.InList -> Operators.UNSUPPORTED;
            case FilterOperator.And -> Operators.UNSUPPORTED;
            case FilterOperator.Or -> Operators.UNSUPPORTED;
            case FilterOperator.Cast -> Operators.CAST;
            case FilterOperator.BitwiseAnd -> Operators.UNSUPPORTED;
            case FilterOperator.BitwiseOr -> Operators.UNSUPPORTED;
            case FilterOperator.InView -> Operators.UNSUPPORTED;
            case FilterOperator.OfType -> Operators.OF_TYPE;
            case FilterOperator.RelatedTo -> Operators.UNSUPPORTED;
        };
    }

    private static Object getAttribute(@NonNull FilterContext context, @NonNull AttributeOperand operand, @NonNull BaseEventTypeNode eventNode) throws UaException {
        throw new UaException(2152136704L);
    }

    private static Object getSimpleAttribute(@NonNull FilterContext context, @NonNull SimpleAttributeOperand operand, @NonNull BaseEventTypeNode eventNode) throws UaException {
        NodeId typeDefinitionId = operand.getTypeDefinitionId();
        if (typeDefinitionId != null && !typeDefinitionId.equals((Object)NodeIds.BaseEventType)) {
            boolean sameOrSubtype;
            NodeId eventTypeDefinitionId = eventNode.getTypeDefinitionNode().getNodeId();
            boolean bl = sameOrSubtype = typeDefinitionId.equals((Object)eventTypeDefinitionId) || EventContentFilter.subtypeOf(eventTypeDefinitionId, typeDefinitionId, context.getServer());
            if (!sameOrSubtype) {
                return null;
            }
        }
        QualifiedName[] browsePath = operand.getBrowsePath();
        UaNode targetNode = eventNode;
        if (browsePath != null) {
            QualifiedName targetBrowsePath;
            Predicate<UaNode> nodePredicate = n -> n.getNodeClass() == NodeClass.Object || n.getNodeClass() == NodeClass.Variable;
            ReferenceTypeTree referenceTypeTree = eventNode.getNodeContext().getServer().getReferenceTypeTree();
            Predicate<Reference> referencePredicate = r -> r.isForward() && referenceTypeTree.isSubtypeOf(r.getReferenceTypeId(), NodeIds.HierarchicalReferences);
            QualifiedName[] qualifiedNameArray = browsePath;
            int n2 = qualifiedNameArray.length;
            for (int i = 0; i < n2 && (targetNode = (UaNode)targetNode.findNode(targetBrowsePath = qualifiedNameArray[i], nodePredicate, referencePredicate).orElse(null)) != null; ++i) {
            }
        }
        if (targetNode != null) {
            AttributeId attributeId = (AttributeId)AttributeId.from((UInteger)operand.getAttributeId()).orElseThrow(() -> new UaException(2150957056L));
            String indexRange = operand.getIndexRange();
            DataValue value = AttributeReader.readAttribute((AccessContext)context, (UaServerNode)targetNode, attributeId, TimestampsToReturn.Neither, indexRange, QualifiedName.NULL_VALUE);
            return value.value().value();
        }
        return null;
    }

    public static boolean subtypeOf(NodeId typeId, NodeId superTypeId, OpcUaServer server) {
        UaNode node = server.getAddressSpaceManager().getManagedNode(typeId).orElse(null);
        if (node instanceof ObjectTypeNode) {
            return EventContentFilter.getParentTypeDefinition(node, server).map(Node::getNodeId).map(id -> id.equals((Object)superTypeId) || EventContentFilter.subtypeOf(id, superTypeId, server)).orElse(false);
        }
        return false;
    }

    private static Optional<UaNode> getParentTypeDefinition(UaNode node, OpcUaServer server) {
        AddressSpaceManager addressSpaceManager = server.getAddressSpaceManager();
        NamespaceTable namespaceTable = server.getNamespaceTable();
        return addressSpaceManager.getManagedReferences(node.getNodeId()).stream().filter(Reference.SUBTYPE_OF).flatMap(r -> r.getTargetNodeId().toNodeId(namespaceTable).stream()).findFirst().flatMap(addressSpaceManager::getManagedNode);
    }

    static class SelectClauseValidationResult {
        private final StatusCode[] statusCodes;
        private final DiagnosticInfo[] diagnosticInfos;

        public SelectClauseValidationResult(StatusCode[] statusCodes, DiagnosticInfo[] diagnosticInfos) {
            this.statusCodes = statusCodes;
            this.diagnosticInfos = diagnosticInfos;
        }
    }

    static class DefaultOperatorContext
    implements OperatorContext {
        private final FilterContext filterContext;
        private final ContentFilterElement[] elements;

        DefaultOperatorContext(FilterContext filterContext, ContentFilterElement[] elements) {
            this.filterContext = filterContext;
            this.elements = elements;
        }

        @Override
        public Optional<Session> getSession() {
            return this.filterContext.getSession();
        }

        @Override
        public OpcUaServer getServer() {
            return this.filterContext.getServer();
        }

        @Override
        public ContentFilterElement[] getElements() {
            return this.elements;
        }

        @Override
        public @Nullable Object resolve(FilterOperand operand, BaseEventTypeNode eventNode) throws UaException {
            if (operand instanceof LiteralOperand) {
                return ((LiteralOperand)operand).getValue().value();
            }
            if (operand instanceof ElementOperand) {
                UInteger index = ((ElementOperand)operand).getIndex();
                ContentFilterElement element = this.elements[index.intValue()];
                return EventContentFilter.evaluate(this, eventNode, element);
            }
            if (operand instanceof AttributeOperand) {
                AttributeOperand ao = (AttributeOperand)operand;
                return EventContentFilter.getAttribute(this.filterContext, ao, eventNode);
            }
            if (operand instanceof SimpleAttributeOperand) {
                SimpleAttributeOperand sao = (SimpleAttributeOperand)operand;
                return EventContentFilter.getSimpleAttribute(this.filterContext, sao, eventNode);
            }
            throw new UaException(2152267776L);
        }
    }
}

