/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SessionDiagnosticsVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class SessionDiagnosticsVariable
extends AbstractLifecycle {
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private AttributeObserver attributeObserver;
    private final OpcUaServer server;
    private final SessionDiagnosticsVariableTypeNode node;
    private final Session session;

    public SessionDiagnosticsVariable(SessionDiagnosticsVariableTypeNode node, Session session) {
        this.node = node;
        this.session = session;
        this.server = node.getNodeContext().getServer();
    }

    public SessionDiagnosticsVariableTypeNode getNode() {
        return this.node;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).value().value()) instanceof Boolean) {
                this.diagnosticsEnabled.set((Boolean)o);
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject xo = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getSessionDiagnosticsDataType());
            return new DataValue(new Variant((Object)xo));
        }));
        this.node.getSessionIdNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            NodeId value = this.session.getSessionDiagnostics().getSessionId();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSessionNameNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionDiagnostics().getSessionName();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getClientDescriptionNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getClientDescription());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getServerUriNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionDiagnostics().getServerUri();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getEndpointUrlNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionDiagnostics().getEndpointUrl();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getLocaleIdsNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String[] value = this.session.getSessionDiagnostics().getLocaleIds();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getActualSessionTimeoutNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            Double value = this.session.getSessionDiagnostics().getActualSessionTimeout();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getMaxResponseMessageSizeNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = this.session.getSessionDiagnostics().getMaxResponseMessageSize();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getClientConnectionTimeNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            DateTime value = this.session.getSessionDiagnostics().getClientConnectionTime();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getClientLastContactTimeNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            DateTime value = this.session.getSessionDiagnostics().getClientLastContactTime();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCurrentSubscriptionsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = this.session.getSessionDiagnostics().getCurrentSubscriptionsCount();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCurrentMonitoredItemsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = this.session.getSessionDiagnostics().getCurrentMonitoredItemsCount();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCurrentPublishRequestsInQueueNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = this.session.getSessionDiagnostics().getCurrentPublishRequestsInQueue();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTotalRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getTotalRequestCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getUnauthorizedRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)this.session.getSessionDiagnostics().getUnauthorizedRequestCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getReadCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getReadCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getHistoryReadCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getHistoryReadCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getWriteCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getWriteCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getHistoryUpdateCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getHistoryUpdateCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCallCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getCallCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCreateMonitoredItemsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getCreateMonitoredItemsCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getModifyMonitoredItemsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getModifyMonitoredItemsCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSetMonitoringModeCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getSetMonitoringModeCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSetTriggeringCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getSetTriggeringCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDeleteMonitoredItemsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getDeleteMonitoredItemsCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCreateSubscriptionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getCreateSubscriptionCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getModifySubscriptionCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getModifySubscriptionCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSetPublishingModeCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getSetPublishingModeCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getPublishCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getPublishCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getRepublishCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getRepublishCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTransferSubscriptionsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getTransferSubscriptionsCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDeleteSubscriptionsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getDeleteSubscriptionsCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getAddNodesCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getAddNodesCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getAddReferencesCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getAddReferencesCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDeleteNodesCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getDeleteNodesCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDeleteReferencesCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getDeleteReferencesCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getBrowseCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getBrowseCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getBrowseNextCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getBrowseNextCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTranslateBrowsePathsToNodeIdsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getTranslateBrowsePathsToNodeIdsCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getQueryFirstCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getQueryFirstCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getQueryNextCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getQueryNextCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getRegisterNodesCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getRegisterNodesCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getUnregisterNodesCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject value = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionDiagnostics().getUnregisterNodesCount().getServiceCounter());
            return new DataValue(new Variant((Object)value));
        }));
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        this.node.delete();
    }
}

