/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;

public class ServiceCounter {
    private final LongAdder totalCount = new LongAdder();
    private final LongAdder errorCount = new LongAdder();

    public void record(CompletionStage<?> completionStage) {
        completionStage.whenComplete((r, ex) -> {
            this.totalCount.increment();
            if (ex != null) {
                this.errorCount.increment();
            }
        });
    }

    public void incrementTotalCount() {
        this.totalCount.increment();
    }

    public void incrementErrorCount() {
        this.errorCount.increment();
    }

    public ServiceCounterDataType getServiceCounter() {
        return new ServiceCounterDataType(Unsigned.uint((long)this.totalCount.sum()), Unsigned.uint((long)this.errorCount.sum()));
    }
}

