/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.util.concurrent.atomic.LongAdder;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;

public class ServerDiagnosticsSummary {
    private final LongAdder cumulatedSessionCount = new LongAdder();
    private final LongAdder securityRejectedSessionCount = new LongAdder();
    private final LongAdder rejectedSessionCount = new LongAdder();
    private final LongAdder sessionTimeoutCount = new LongAdder();
    private final LongAdder sessionAbortCount = new LongAdder();
    private final LongAdder cumulatedSubscriptionCount = new LongAdder();
    private final LongAdder securityRejectedRequestCount = new LongAdder();
    private final LongAdder rejectedRequestCount = new LongAdder();
    private final OpcUaServer server;

    public ServerDiagnosticsSummary(OpcUaServer server) {
        this.server = server;
    }

    public UInteger getCurrentViewCount() {
        return this.server.getAddressSpaceManager().getViewCount();
    }

    public UInteger getCurrentSessionCount() {
        return this.server.getSessionManager().getCurrentSessionCount();
    }

    public LongAdder getCumulatedSessionCount() {
        return this.cumulatedSessionCount;
    }

    public LongAdder getSecurityRejectedSessionCount() {
        return this.securityRejectedSessionCount;
    }

    public LongAdder getRejectedSessionCount() {
        return this.rejectedSessionCount;
    }

    public LongAdder getSessionTimeoutCount() {
        return this.sessionTimeoutCount;
    }

    public LongAdder getSessionAbortCount() {
        return this.sessionAbortCount;
    }

    public UInteger getCurrentSubscriptionCount() {
        return Unsigned.uint((int)this.server.getSubscriptions().size());
    }

    public LongAdder getCumulatedSubscriptionCount() {
        return this.cumulatedSubscriptionCount;
    }

    public UInteger getPublishingIntervalCount() {
        return Unsigned.uint((long)this.server.getSubscriptions().values().stream().map(Subscription::getPublishingInterval).distinct().count());
    }

    public UInteger getSecurityRejectedRequestCount() {
        return Unsigned.uint((long)this.securityRejectedRequestCount.sum());
    }

    public UInteger getRejectedRequestCount() {
        return Unsigned.uint((long)this.rejectedRequestCount.sum());
    }

    public ServerDiagnosticsSummaryDataType getServerDiagnosticsSummaryDataType() {
        return new ServerDiagnosticsSummaryDataType(this.getCurrentViewCount(), this.getCurrentSessionCount(), Unsigned.uint((long)this.getCumulatedSessionCount().sum()), Unsigned.uint((long)this.getSecurityRejectedSessionCount().sum()), Unsigned.uint((long)this.getRejectedSessionCount().sum()), Unsigned.uint((long)this.getSessionTimeoutCount().sum()), Unsigned.uint((long)this.getSessionAbortCount().sum()), this.getCurrentSubscriptionCount(), Unsigned.uint((long)this.getCumulatedSubscriptionCount().sum()), this.getPublishingIntervalCount(), this.getSecurityRejectedRequestCount(), this.getRejectedRequestCount());
    }
}

