/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class VariableTypeManager {
    private final ConcurrentMap<NodeId, VariableTypeDefinition> typeDefinitions = new ConcurrentHashMap<NodeId, VariableTypeDefinition>();

    public void registerVariableType(NodeId typeDefinition, Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor variableNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new VariableTypeDefinition(nodeClass, variableNodeConstructor));
    }

    public void registerVariableType(NodeId typeDefinition, Class<? extends UaVariableNode> nodeClass, final LegacyVariableNodeConstructor variableNodeConstructor) {
        VariableNodeConstructor adapted = new VariableNodeConstructor(){

            @Override
            public UaVariableNode apply(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions) {
                return variableNodeConstructor.apply(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
            }
        };
        this.typeDefinitions.put(typeDefinition, new VariableTypeDefinition(nodeClass, adapted));
    }

    public Optional<VariableNodeConstructor> getNodeConstructor(NodeId typeDefinition) {
        VariableTypeDefinition def = (VariableTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeConstructor);
    }

    private static class VariableTypeDefinition {
        final Class<? extends UaVariableNode> nodeClass;
        final VariableNodeConstructor nodeConstructor;

        private VariableTypeDefinition(Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor nodeConstructor) {
            this.nodeClass = nodeClass;
            this.nodeConstructor = nodeConstructor;
        }
    }

    @FunctionalInterface
    public static interface VariableNodeConstructor {
        public UaVariableNode apply(UaNodeContext var1, NodeId var2, QualifiedName var3, LocalizedText var4, LocalizedText var5, UInteger var6, UInteger var7, RolePermissionType[] var8, RolePermissionType[] var9, AccessRestrictionType var10, DataValue var11, NodeId var12, Integer var13, UInteger[] var14);
    }

    @FunctionalInterface
    public static interface LegacyVariableNodeConstructor {
        public UaVariableNode apply(UaNodeContext var1, NodeId var2, QualifiedName var3, LocalizedText var4, LocalizedText var5, UInteger var6, UInteger var7);
    }
}

