/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteAtTimeDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteEventDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteRawModifiedDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.UpdateDataDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.UpdateEventDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.UpdateStructureDataDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public abstract class SimpleAddressSpaceFilter
implements AddressSpaceFilter {
    public static SimpleAddressSpaceFilter create(Predicate<NodeId> nodeIdFilter) {
        return SimpleAddressSpaceFilter.create(nodeIdFilter, nodeIdFilter);
    }

    public static SimpleAddressSpaceFilter create(final Predicate<NodeId> nodeIdFilter, final Predicate<NodeId> monitoredItemFilter) {
        return new SimpleAddressSpaceFilter(){

            @Override
            protected boolean filterNode(NodeId nodeId) {
                return nodeIdFilter.test(nodeId);
            }

            @Override
            protected boolean filterMonitoredItem(NodeId nodeId) {
                return monitoredItemFilter.test(nodeId);
            }
        };
    }

    protected abstract boolean filterNode(NodeId var1);

    protected abstract boolean filterMonitoredItem(NodeId var1);

    @Override
    public boolean filterBrowse(OpcUaServer server, NodeId nodeId) {
        return this.filterNode(nodeId);
    }

    @Override
    public boolean filterRegisterNode(OpcUaServer server, NodeId nodeId) {
        return this.filterNode(nodeId);
    }

    @Override
    public boolean filterUnregisterNode(OpcUaServer server, NodeId nodeId) {
        return this.filterNode(nodeId);
    }

    @Override
    public boolean filterRead(OpcUaServer server, ReadValueId readValueId) {
        return this.filterNode(readValueId.getNodeId());
    }

    @Override
    public boolean filterWrite(OpcUaServer server, WriteValue writeValue) {
        return this.filterNode(writeValue.getNodeId());
    }

    @Override
    public boolean filterHistoryRead(OpcUaServer server, HistoryReadValueId historyReadValueId) {
        return this.filterNode(historyReadValueId.getNodeId());
    }

    @Override
    public boolean filterHistoryUpdate(OpcUaServer server, HistoryUpdateDetails historyUpdateDetails) {
        if (historyUpdateDetails instanceof DeleteAtTimeDetails) {
            DeleteAtTimeDetails details = (DeleteAtTimeDetails)historyUpdateDetails;
            return this.filterNode(details.getNodeId());
        }
        if (historyUpdateDetails instanceof DeleteEventDetails) {
            DeleteEventDetails details = (DeleteEventDetails)historyUpdateDetails;
            return this.filterNode(details.getNodeId());
        }
        if (historyUpdateDetails instanceof DeleteRawModifiedDetails) {
            DeleteRawModifiedDetails details = (DeleteRawModifiedDetails)historyUpdateDetails;
            return this.filterNode(details.getNodeId());
        }
        if (historyUpdateDetails instanceof UpdateDataDetails) {
            UpdateDataDetails details = (UpdateDataDetails)historyUpdateDetails;
            return this.filterNode(details.getNodeId());
        }
        if (historyUpdateDetails instanceof UpdateEventDetails) {
            UpdateEventDetails details = (UpdateEventDetails)historyUpdateDetails;
            return this.filterNode(details.getNodeId());
        }
        if (historyUpdateDetails instanceof UpdateStructureDataDetails) {
            UpdateStructureDataDetails details = (UpdateStructureDataDetails)historyUpdateDetails;
            return this.filterNode(details.getNodeId());
        }
        throw new IllegalArgumentException("unexpected HistoryUpdateDetails: " + String.valueOf(historyUpdateDetails));
    }

    @Override
    public boolean filterCall(OpcUaServer server, CallMethodRequest callMethodRequest) {
        return this.filterNode(callMethodRequest.getObjectId());
    }

    @Override
    public boolean filterOnCreateDataItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnModifyDataItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnCreateEventItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnModifyEventItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnDataItemsCreated(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnDataItemsModified(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnDataItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnEventItemsCreated(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnEventItemsModified(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnEventItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnMonitoringModeChanged(OpcUaServer server, ReadValueId readValueId) {
        return this.filterMonitoredItem(readValueId.getNodeId());
    }

    @Override
    public boolean filterAddNodes(OpcUaServer server, AddNodesItem addNodesItem) {
        NamespaceTable namespaceTable = server.getNamespaceTable();
        ExpandedNodeId requestedNewNodeId = addNodesItem.getRequestedNewNodeId();
        if (requestedNewNodeId.isNotNull()) {
            return requestedNewNodeId.toNodeId(namespaceTable).map(this::filterNode).orElse(false);
        }
        return addNodesItem.getParentNodeId().toNodeId(namespaceTable).map(this::filterNode).orElse(false);
    }

    @Override
    public boolean filterDeleteNodes(OpcUaServer server, DeleteNodesItem deleteNodesItem) {
        return this.filterNode(deleteNodesItem.getNodeId());
    }

    @Override
    public boolean filterAddReferences(OpcUaServer server, AddReferencesItem addReferencesItem) {
        return this.filterNode(addReferencesItem.getSourceNodeId());
    }

    @Override
    public boolean filterDeleteReferences(OpcUaServer server, DeleteReferencesItem deleteReferencesItem) {
        return this.filterNode(deleteReferencesItem.getSourceNodeId());
    }
}

