/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.core.typetree.DataTypeTree;
import org.eclipse.milo.opcua.sdk.core.typetree.ReferenceTypeTree;
import org.eclipse.milo.opcua.sdk.server.AbstractServiceHandler;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.EndpointConfig;
import org.eclipse.milo.opcua.sdk.server.EventListener;
import org.eclipse.milo.opcua.sdk.server.EventNotifier;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.RoleMapper;
import org.eclipse.milo.opcua.sdk.server.SessionManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ServerDiagnosticsSummary;
import org.eclipse.milo.opcua.sdk.server.model.ObjectTypeInitializer;
import org.eclipse.milo.opcua.sdk.server.model.VariableTypeInitializer;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.namespaces.OpcUaNamespace;
import org.eclipse.milo.opcua.sdk.server.namespaces.ServerNamespace;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.EventFactory;
import org.eclipse.milo.opcua.sdk.server.servicesets.Service;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.AccessController;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultAccessController;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultAttributeServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultDiscoveryServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultMethodServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultMonitoredItemServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultNodeManagementServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultSessionServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultSubscriptionServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.DefaultViewServiceSet;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.typetree.DataTypeTreeBuilder;
import org.eclipse.milo.opcua.sdk.server.typetree.ReferenceTypeTreeBuilder;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.ServerTable;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.encoding.DefaultEncodingManager;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingManager;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.eclipse.milo.opcua.stack.core.util.ManifestUtil;
import org.eclipse.milo.opcua.stack.transport.server.OpcServerTransport;
import org.eclipse.milo.opcua.stack.transport.server.OpcServerTransportFactory;
import org.eclipse.milo.opcua.stack.transport.server.ServerApplicationContext;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;
import org.eclipse.milo.shaded.com.google.common.collect.Sets;
import org.eclipse.milo.shaded.com.google.common.eventbus.EventBus;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaServer
extends AbstractServiceHandler {
    public static final String SDK_VERSION = ManifestUtil.read((String)"X-SDK-Version").orElse("dev");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lazy<ApplicationDescription> applicationDescription = new Lazy();
    private final Map<UInteger, Subscription> subscriptions = new ConcurrentHashMap<UInteger, Subscription>();
    private final AtomicLong monitoredItemCount = new AtomicLong(0L);
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final ServerTable serverTable = new ServerTable();
    private final AddressSpaceManager addressSpaceManager = new AddressSpaceManager(this);
    private final SessionManager sessionManager;
    private final EncodingManager encodingManager = DefaultEncodingManager.createAndInitialize();
    private final ObjectTypeManager objectTypeManager = new ObjectTypeManager();
    private final VariableTypeManager variableTypeManager = new VariableTypeManager();
    private final Lazy<DataTypeTree> dataTypeTree = new Lazy();
    private final Lazy<ReferenceTypeTree> referenceTypeTree = new Lazy();
    private final DataTypeManager staticDataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.namespaceTable);
    private final DataTypeManager dynamicDataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.namespaceTable);
    private final Set<NodeId> registeredViews = Sets.newConcurrentHashSet();
    private final ServerDiagnosticsSummary diagnosticsSummary = new ServerDiagnosticsSummary(this);
    private final Lazy<List<EndpointDescription>> endpointDescriptions = new Lazy();
    private final List<EndpointConfig> boundEndpoints = new CopyOnWriteArrayList<EndpointConfig>();
    private final LongSequence secureChannelIds = new LongSequence(1L, 0xFFFFFFFFL, (long)(new Random().nextInt(0x7FFFFFFE) + 1));
    private final AtomicLong secureChannelTokenIds = new AtomicLong();
    private final Map<TransportProfile, OpcServerTransport> transports = new ConcurrentHashMap<TransportProfile, OpcServerTransport>();
    private final EventBus eventBus = new EventBus("server");
    private final EventFactory eventFactory = new EventFactory(this);
    private final EventNotifier eventNotifier = new ServerEventNotifier();
    private final EncodingContext staticEncodingContext;
    private final EncodingContext dynamicEncodingContext;
    private final OpcUaNamespace opcUaNamespace;
    private final ServerNamespace serverNamespace;
    private final AccessController accessController;
    private final OpcUaServerConfig config;
    private final OpcServerTransportFactory transportFactory;
    private final ServerApplicationContext applicationContext;

    public OpcUaServer(final OpcUaServerConfig config, OpcServerTransportFactory transportFactory) {
        this.config = config;
        this.transportFactory = transportFactory;
        this.applicationContext = new ServerApplicationContextImpl();
        this.staticEncodingContext = new EncodingContext(){

            public DataTypeManager getDataTypeManager() {
                return OpcUaServer.this.staticDataTypeManager;
            }

            public EncodingManager getEncodingManager() {
                return OpcUaServer.this.encodingManager;
            }

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return OpcUaServer.this.namespaceTable;
            }

            public ServerTable getServerTable() {
                return OpcUaServer.this.serverTable;
            }
        };
        this.dynamicEncodingContext = new EncodingContext(){

            public DataTypeManager getDataTypeManager() {
                return OpcUaServer.this.dynamicDataTypeManager;
            }

            public EncodingManager getEncodingManager() {
                return OpcUaServer.this.encodingManager;
            }

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return OpcUaServer.this.namespaceTable;
            }

            public ServerTable getServerTable() {
                return OpcUaServer.this.serverTable;
            }
        };
        Stream<String> paths = config.getEndpoints().stream().map(e -> EndpointUtil.getPath((String)e.getEndpointUrl())).distinct();
        paths.forEach(path -> {
            this.addServiceSet((String)path, new DefaultDiscoveryServiceSet(this));
            if (!path.endsWith("/discovery")) {
                this.addServiceSet((String)path, new DefaultAttributeServiceSet(this));
                this.addServiceSet((String)path, new DefaultMethodServiceSet(this));
                this.addServiceSet((String)path, new DefaultMonitoredItemServiceSet(this));
                this.addServiceSet((String)path, new DefaultNodeManagementServiceSet(this));
                this.addServiceSet((String)path, new DefaultSessionServiceSet(this));
                this.addServiceSet((String)path, new DefaultSubscriptionServiceSet(this));
                this.addServiceSet((String)path, new DefaultViewServiceSet(this));
            }
        });
        ObjectTypeInitializer.initialize(this.namespaceTable, this.objectTypeManager);
        VariableTypeInitializer.initialize(this.namespaceTable, this.variableTypeManager);
        this.serverTable.add(config.getApplicationUri());
        this.sessionManager = new SessionManager(this, config.getExecutor());
        this.opcUaNamespace = new OpcUaNamespace(this);
        this.opcUaNamespace.startup();
        this.serverNamespace = new ServerNamespace(this);
        this.serverNamespace.startup();
        this.accessController = new DefaultAccessController(this);
    }

    public CompletableFuture<OpcUaServer> startup() {
        this.eventFactory.startup();
        this.config.getEndpoints().stream().sorted(Comparator.comparing(EndpointConfig::getTransportProfile)).forEach(endpoint -> {
            this.logger.info("Binding endpoint {} to {}:{} [{}/{}]", new Object[]{endpoint.getEndpointUrl(), endpoint.getBindAddress(), endpoint.getBindPort(), endpoint.getSecurityPolicy(), endpoint.getSecurityMode()});
            TransportProfile transportProfile = endpoint.getTransportProfile();
            OpcServerTransport transport = this.transports.computeIfAbsent(transportProfile, arg_0 -> ((OpcServerTransportFactory)this.transportFactory).create(arg_0));
            if (transport != null) {
                try {
                    InetSocketAddress bindAddress = new InetSocketAddress(endpoint.getBindAddress(), endpoint.getBindPort());
                    transport.bind(this.applicationContext, bindAddress);
                    this.transports.put(transportProfile, transport);
                    this.boundEndpoints.add((EndpointConfig)endpoint);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to bind endpoint {} to {}:{} [{}/{}]", new Object[]{endpoint.getEndpointUrl(), endpoint.getBindAddress(), endpoint.getBindPort(), endpoint.getSecurityPolicy(), endpoint.getSecurityMode(), e});
                }
            } else {
                this.logger.warn("No OpcServerTransport for TransportProfile: {}", (Object)transportProfile);
            }
        });
        if (this.boundEndpoints.isEmpty()) {
            return CompletableFuture.failedFuture(new UaException(0x80890000L, "No endpoints bound"));
        }
        return CompletableFuture.completedFuture(this);
    }

    public CompletableFuture<OpcUaServer> shutdown() {
        this.transports.values().forEach(transport -> {
            try {
                transport.unbind();
            }
            catch (Exception e) {
                this.logger.warn("Error unbinding transport", (Throwable)e);
            }
        });
        this.transports.clear();
        this.serverNamespace.shutdown();
        this.opcUaNamespace.shutdown();
        this.eventFactory.shutdown();
        this.subscriptions.values().forEach(Subscription::deleteSubscription);
        return CompletableFuture.completedFuture(this);
    }

    public OpcUaServerConfig getConfig() {
        return this.config;
    }

    public AccessController getAccessController() {
        return this.accessController;
    }

    public ServerApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AddressSpaceManager getAddressSpaceManager() {
        return this.addressSpaceManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public OpcUaNamespace getOpcUaNamespace() {
        return this.opcUaNamespace;
    }

    public ServerNamespace getServerNamespace() {
        return this.serverNamespace;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public DataTypeManager getStaticDataTypeManager() {
        return this.staticDataTypeManager;
    }

    public DataTypeManager getDynamicDataTypeManager() {
        return this.dynamicDataTypeManager;
    }

    public EncodingContext getStaticEncodingContext() {
        return this.staticEncodingContext;
    }

    public EncodingContext getDynamicEncodingContext() {
        return this.dynamicEncodingContext;
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public ServerDiagnosticsSummary getDiagnosticsSummary() {
        return this.diagnosticsSummary;
    }

    public EventBus getInternalEventBus() {
        return this.eventBus;
    }

    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public EventNotifier getEventNotifier() {
        return this.eventNotifier;
    }

    public ObjectTypeManager getObjectTypeManager() {
        return this.objectTypeManager;
    }

    public VariableTypeManager getVariableTypeManager() {
        return this.variableTypeManager;
    }

    public DataTypeTree getDataTypeTree() {
        return (DataTypeTree)this.dataTypeTree.get(() -> DataTypeTreeBuilder.build(this));
    }

    public DataTypeTree updateDataTypeTree() {
        this.dataTypeTree.reset();
        return this.getDataTypeTree();
    }

    public ReferenceTypeTree getReferenceTypeTree() {
        return (ReferenceTypeTree)this.referenceTypeTree.get(() -> ReferenceTypeTreeBuilder.build(this));
    }

    public ReferenceTypeTree updateReferenceTypeTree() {
        this.referenceTypeTree.reset();
        return this.getReferenceTypeTree();
    }

    public Set<NodeId> getRegisteredViews() {
        return this.registeredViews;
    }

    public Map<UInteger, Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public AtomicLong getMonitoredItemCount() {
        return this.monitoredItemCount;
    }

    public Optional<KeyPair> getKeyPair(ByteString thumbprint) {
        return this.config.getCertificateManager().getKeyPair(thumbprint);
    }

    public Optional<X509Certificate> getCertificate(ByteString thumbprint) {
        return this.config.getCertificateManager().getCertificate(thumbprint);
    }

    public Optional<X509Certificate[]> getCertificateChain(ByteString thumbprint) {
        return this.config.getCertificateManager().getCertificateChain(thumbprint);
    }

    public ExecutorService getExecutorService() {
        return this.config.getExecutor();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.config.getScheduledExecutorService();
    }

    public Optional<RoleMapper> getRoleMapper() {
        return this.config.getRoleMapper();
    }

    public List<EndpointConfig> getBoundEndpoints() {
        return List.copyOf(this.boundEndpoints);
    }

    public void resetEndpointDescriptionCache() {
        this.endpointDescriptions.reset();
    }

    static {
        Logger logger = LoggerFactory.getLogger(OpcUaServer.class);
        logger.info("Java version: {}", (Object)System.getProperty("java.version"));
        logger.info("Eclipse Milo OPC UA Stack version: {}", (Object)Stack.VERSION);
        logger.info("Eclipse Milo OPC UA Server SDK version: {}", (Object)SDK_VERSION);
    }

    private static class ServerEventNotifier
    implements EventNotifier {
        private final List<EventListener> eventListeners = Collections.synchronizedList(new ArrayList());

        private ServerEventNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(BaseEventTypeNode event) {
            List<EventListener> toNotify;
            List<EventListener> list = this.eventListeners;
            synchronized (list) {
                toNotify = List.copyOf(this.eventListeners);
            }
            toNotify.forEach(eventListener -> eventListener.onEvent(event));
        }

        @Override
        public void register(EventListener eventListener) {
            this.eventListeners.add(eventListener);
        }

        @Override
        public void unregister(EventListener eventListener) {
            this.eventListeners.remove(eventListener);
        }
    }

    private class ServerApplicationContextImpl
    implements ServerApplicationContext {
        private ServerApplicationContextImpl() {
        }

        public List<EndpointDescription> getEndpointDescriptions() {
            return (List)OpcUaServer.this.endpointDescriptions.get(() -> OpcUaServer.this.config.getEndpoints().stream().map(this::transformEndpoint).toList());
        }

        public EncodingContext getEncodingContext() {
            return OpcUaServer.this.staticEncodingContext;
        }

        public CertificateManager getCertificateManager() {
            return OpcUaServer.this.config.getCertificateManager();
        }

        public Long getNextSecureChannelId() {
            return OpcUaServer.this.secureChannelIds.getAndIncrement();
        }

        public Long getNextSecureChannelTokenId() {
            return OpcUaServer.this.secureChannelTokenIds.getAndIncrement();
        }

        public CompletableFuture<UaResponseMessageType> handleServiceRequest(ServiceRequestContext context, UaRequestMessageType requestMessage) {
            CompletableFuture<UaResponseMessageType> future = new CompletableFuture<UaResponseMessageType>();
            OpcUaServer.this.getExecutorService().execute(() -> this.handleServiceRequest(context, requestMessage, future));
            return future;
        }

        private void handleServiceRequest(ServiceRequestContext context, UaRequestMessageType requestMessage, CompletableFuture<UaResponseMessageType> future) {
            AbstractServiceHandler.ServiceHandler serviceHandler;
            String path = EndpointUtil.getPath((String)context.getEndpointUrl());
            if (context.getSecureChannel().getSecurityPolicy() == SecurityPolicy.None && this.getEndpointDescriptions().stream().filter(e -> EndpointUtil.getPath((String)e.getEndpointUrl()).equals(path)).filter(e -> Objects.equals(e.getTransportProfileUri(), context.getTransportProfile().getUri())).noneMatch(e -> Objects.equals(e.getSecurityPolicyUri(), SecurityPolicy.None.getUri())) && !this.isDiscoveryService(requestMessage)) {
                ErrorMessage errorMessage = new ErrorMessage(0x80550000L, StatusCodes.lookup((long)0x80550000L).map(ss -> ss[1]).orElse(""));
                context.getChannel().pipeline().fireUserEventTriggered((Object)errorMessage);
                future.completeExceptionally(new UaException(0x80550000L));
                return;
            }
            Service service = Service.from(requestMessage.getTypeId());
            AbstractServiceHandler.ServiceHandler serviceHandler2 = serviceHandler = service != null ? OpcUaServer.this.getServiceHandler(path, service) : null;
            if (serviceHandler != null) {
                if (OpcUaServer.this.logger.isTraceEnabled()) {
                    OpcUaServer.this.logger.trace("Service request received: path={} handle={} service={} remote={}", new Object[]{path, requestMessage.getRequestHeader().getRequestHandle(), service, context.getChannel().remoteAddress()});
                }
                if (serviceHandler instanceof AbstractServiceHandler.AsyncServiceHandler) {
                    AbstractServiceHandler.AsyncServiceHandler asyncServiceHandler = (AbstractServiceHandler.AsyncServiceHandler)serviceHandler;
                    CompletionStage response = asyncServiceHandler.handleAsync(context, requestMessage).whenComplete((r, ex) -> {
                        if (ex != null) {
                            OpcUaServer.this.logger.debug("Service request completed exceptionally: path={} handle={} service={} remote={}", new Object[]{path, requestMessage.getRequestHeader().getRequestHandle(), service, context.getChannel().remoteAddress(), ex});
                        } else if (OpcUaServer.this.logger.isTraceEnabled()) {
                            OpcUaServer.this.logger.trace("Service request completed: path={} handle={} service={} remote={}", new Object[]{path, requestMessage.getRequestHeader().getRequestHandle(), service, context.getChannel().remoteAddress()});
                        }
                    });
                    FutureUtils.complete(future).with((CompletableFuture)response);
                } else {
                    try {
                        UaResponseMessageType response = serviceHandler.handle(context, requestMessage);
                        if (OpcUaServer.this.logger.isTraceEnabled()) {
                            OpcUaServer.this.logger.trace("Service request completed: path={} handle={} service={} remote={}", new Object[]{path, requestMessage.getRequestHeader().getRequestHandle(), service, context.getChannel().remoteAddress()});
                        }
                        future.complete(response);
                    }
                    catch (UaException e2) {
                        OpcUaServer.this.logger.debug("Service request completed exceptionally: path={} handle={} service={} remote={}", new Object[]{path, requestMessage.getRequestHeader().getRequestHandle(), service, context.getChannel().remoteAddress(), e2});
                        future.completeExceptionally(e2);
                    }
                }
            } else {
                OpcUaServer.this.logger.warn("No ServiceHandler registered for path={} service={}", (Object)path, (Object)service);
                future.completeExceptionally(new UaException(0x80400000L));
            }
        }

        private boolean isDiscoveryService(UaRequestMessageType requestMessage) {
            Service service = Service.from(requestMessage.getTypeId());
            if (service != null) {
                return switch (service) {
                    case Service.DISCOVERY_FIND_SERVERS, Service.DISCOVERY_GET_ENDPOINTS, Service.DISCOVERY_REGISTER_SERVER, Service.DISCOVERY_FIND_SERVERS_ON_NETWORK, Service.DISCOVERY_REGISTER_SERVER_2 -> true;
                    default -> false;
                };
            }
            return false;
        }

        private EndpointDescription transformEndpoint(EndpointConfig endpoint) {
            return new EndpointDescription(endpoint.getEndpointUrl(), this.getApplicationDescription(), this.certificateByteString(endpoint.getCertificate()), endpoint.getSecurityMode(), endpoint.getSecurityPolicy().getUri(), endpoint.getTokenPolicies().toArray(new UserTokenPolicy[0]), endpoint.getTransportProfile().getUri(), Unsigned.ubyte((short)this.getSecurityLevel(endpoint.getSecurityPolicy(), endpoint.getSecurityMode())));
        }

        private ByteString certificateByteString(@Nullable X509Certificate certificate) {
            if (certificate != null) {
                try {
                    return ByteString.of((byte[])certificate.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    OpcUaServer.this.logger.error("Error decoding certificate.", (Throwable)e);
                    return ByteString.NULL_VALUE;
                }
            }
            return ByteString.NULL_VALUE;
        }

        private ApplicationDescription getApplicationDescription() {
            return (ApplicationDescription)OpcUaServer.this.applicationDescription.get(() -> {
                List<Object> discoveryUrls = OpcUaServer.this.config.getEndpoints().stream().map(EndpointConfig::getEndpointUrl).filter(url -> url.endsWith("/discovery")).distinct().collect(Collectors.toList());
                if (discoveryUrls.isEmpty()) {
                    discoveryUrls = OpcUaServer.this.config.getEndpoints().stream().map(EndpointConfig::getEndpointUrl).distinct().toList();
                }
                return new ApplicationDescription(OpcUaServer.this.config.getApplicationUri(), OpcUaServer.this.config.getProductUri(), OpcUaServer.this.config.getApplicationName(), ApplicationType.Server, null, null, discoveryUrls.toArray(new String[0]));
            });
        }

        private short getSecurityLevel(SecurityPolicy securityPolicy, MessageSecurityMode securityMode) {
            short securityLevel = 0;
            switch (securityPolicy) {
                case Aes256_Sha256_RsaPss: 
                case Basic256Sha256: {
                    securityLevel = (short)(securityLevel | 8);
                    break;
                }
                case Aes128_Sha256_RsaOaep: {
                    securityLevel = (short)(securityLevel | 4);
                    break;
                }
                case Basic256: 
                case Basic128Rsa15: {
                    securityLevel = (short)(securityLevel | 1);
                    break;
                }
            }
            switch (securityMode) {
                case SignAndEncrypt: {
                    securityLevel = (short)(securityLevel | 0x80);
                    break;
                }
                case Sign: {
                    securityLevel = (short)(securityLevel | 0x40);
                    break;
                }
                default: {
                    securityLevel = (short)(securityLevel | 0x20);
                }
            }
            return securityLevel;
        }
    }
}

