/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.UUID;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.ManagedAddressSpaceFragment;
import org.eclipse.milo.opcua.sdk.server.Namespace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.SimpleAddressSpaceFilter;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public abstract class ManagedNamespace
extends ManagedAddressSpaceFragment
implements Namespace {
    private final AddressSpaceFilter filter;
    private final String namespaceUri;
    private final UShort namespaceIndex;

    public ManagedNamespace(OpcUaServer server, String namespaceUri) {
        super(server);
        this.namespaceUri = namespaceUri;
        this.namespaceIndex = (UShort)server.getNamespaceTable().add(namespaceUri);
        this.filter = SimpleAddressSpaceFilter.create(nodeId -> nodeId.getNamespaceIndex().equals((Object)this.getNamespaceIndex()));
    }

    @Override
    public AddressSpaceFilter getFilter() {
        return this.filter;
    }

    @Override
    public final String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public final UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    protected final NodeId newNodeId(long id) {
        return new NodeId(this.namespaceIndex, Unsigned.uint((long)id));
    }

    protected final NodeId newNodeId(UInteger id) {
        return new NodeId(this.namespaceIndex, id);
    }

    protected final NodeId newNodeId(String id) {
        return new NodeId(this.namespaceIndex, id);
    }

    protected final NodeId newNodeId(UUID id) {
        return new NodeId(this.namespaceIndex, id);
    }

    protected final NodeId newNodeId(ByteString id) {
        return new NodeId(this.namespaceIndex, id);
    }

    protected final QualifiedName newQualifiedName(String name) {
        return new QualifiedName(this.namespaceIndex, name);
    }
}

