/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Collections;
import java.util.List;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.ServiceOperationContext;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.EventItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResult;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.jspecify.annotations.Nullable;

public interface AddressSpace {
    public List<DataValue> read(ReadContext var1, Double var2, TimestampsToReturn var3, List<ReadValueId> var4);

    public List<StatusCode> write(WriteContext var1, List<WriteValue> var2);

    default public List<HistoryReadResult> historyRead(HistoryReadContext context, HistoryReadDetails readDetails, TimestampsToReturn timestamps, List<HistoryReadValueId> readValueIds) {
        HistoryReadResult result = new HistoryReadResult(new StatusCode(2154954752L), null, null);
        return Collections.nCopies(readValueIds.size(), result);
    }

    default public List<HistoryUpdateResult> historyUpdate(HistoryUpdateContext context, List<HistoryUpdateDetails> updateDetails) {
        HistoryUpdateResult result = new HistoryUpdateResult(new StatusCode(2154954752L), null, null);
        return Collections.nCopies(updateDetails.size(), result);
    }

    default public List<CallMethodResult> call(CallContext context, List<CallMethodRequest> requests) {
        CallMethodResult result = new CallMethodResult(new StatusCode(0x80400000L), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]);
        return Collections.nCopies(requests.size(), result);
    }

    default public RevisedDataItemParameters onCreateDataItem(ReadValueId itemToMonitor, Double requestedSamplingInterval, UInteger requestedQueueSize) {
        return new RevisedDataItemParameters(requestedSamplingInterval, requestedQueueSize);
    }

    default public RevisedDataItemParameters onModifyDataItem(ReadValueId itemToModify, Double requestedSamplingInterval, UInteger requestedQueueSize) {
        return new RevisedDataItemParameters(requestedSamplingInterval, requestedQueueSize);
    }

    default public RevisedEventItemParameters onCreateEventItem(ReadValueId itemToMonitor, UInteger requestedQueueSize) {
        return new RevisedEventItemParameters(requestedQueueSize);
    }

    default public RevisedEventItemParameters onModifyEventItem(ReadValueId itemToModify, UInteger requestedQueueSize) {
        return new RevisedEventItemParameters(requestedQueueSize);
    }

    public void onDataItemsCreated(List<DataItem> var1);

    public void onDataItemsModified(List<DataItem> var1);

    public void onDataItemsDeleted(List<DataItem> var1);

    default public void onEventItemsCreated(List<EventItem> eventItems) {
    }

    default public void onEventItemsModified(List<EventItem> eventItems) {
    }

    default public void onEventItemsDeleted(List<EventItem> eventItems) {
    }

    public void onMonitoringModeChanged(List<MonitoredItem> var1);

    default public List<AddNodesResult> addNodes(AddNodesContext context, List<AddNodesItem> nodesToAdd) {
        AddNodesResult result = new AddNodesResult(new StatusCode(2151481344L), NodeId.NULL_VALUE);
        return Collections.nCopies(nodesToAdd.size(), result);
    }

    default public List<StatusCode> deleteNodes(DeleteNodesContext context, List<DeleteNodesItem> nodesToDelete) {
        StatusCode statusCode = new StatusCode(2151481344L);
        return Collections.nCopies(nodesToDelete.size(), statusCode);
    }

    default public List<StatusCode> addReferences(AddReferencesContext context, List<AddReferencesItem> referencesToAdd) {
        StatusCode statusCode = new StatusCode(2151481344L);
        return Collections.nCopies(referencesToAdd.size(), statusCode);
    }

    default public List<StatusCode> deleteReferences(DeleteReferencesContext context, List<DeleteReferencesItem> referencesToDelete) {
        StatusCode statusCode = new StatusCode(2151481344L);
        return Collections.nCopies(referencesToDelete.size(), statusCode);
    }

    public List<ReferenceResult> browse(BrowseContext var1, ViewDescription var2, List<NodeId> var3);

    public ReferenceResult.ReferenceList gather(BrowseContext var1, ViewDescription var2, NodeId var3);

    default public List<NodeId> registerNodes(RegisterNodesContext context, List<NodeId> nodeIds) {
        return nodeIds;
    }

    default public void unregisterNodes(UnregisterNodesContext context, List<NodeId> nodeIds) {
    }

    default public UInteger getViewCount() {
        return Unsigned.uint((int)0);
    }

    public record RevisedDataItemParameters(Double revisedSamplingInterval, UInteger revisedQueueSize) {
    }

    public record RevisedEventItemParameters(UInteger revisedQueueSize) {
    }

    public static final class UnregisterNodesContext
    extends ServiceOperationContext<NodeId> {
        public UnregisterNodesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public UnregisterNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<NodeId> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class RegisterNodesContext
    extends ServiceOperationContext<NodeId> {
        public RegisterNodesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public RegisterNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<NodeId> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class BrowseContext
    extends ServiceOperationContext<NodeId> {
        public BrowseContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public BrowseContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<NodeId> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class DeleteReferencesContext
    extends ServiceOperationContext<DeleteReferencesItem> {
        public DeleteReferencesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public DeleteReferencesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<DeleteReferencesItem> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class AddReferencesContext
    extends ServiceOperationContext<AddReferencesItem> {
        public AddReferencesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public AddReferencesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<AddReferencesItem> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class DeleteNodesContext
    extends ServiceOperationContext<DeleteNodesItem> {
        public DeleteNodesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public DeleteNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<DeleteNodesItem> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class AddNodesContext
    extends ServiceOperationContext<AddNodesItem> {
        public AddNodesContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public AddNodesContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<AddNodesItem> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class CallContext
    extends ServiceOperationContext<CallMethodRequest> {
        public CallContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public CallContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<CallMethodRequest> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class HistoryUpdateContext
    extends ServiceOperationContext<HistoryUpdateDetails> {
        public HistoryUpdateContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public HistoryUpdateContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<HistoryUpdateDetails> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class HistoryReadContext
    extends ServiceOperationContext<HistoryReadValueId> {
        public HistoryReadContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public HistoryReadContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<HistoryReadValueId> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class WriteContext
    extends ServiceOperationContext<WriteValue> {
        public WriteContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public WriteContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<WriteValue> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    public static final class ReadContext
    extends ServiceOperationContext<ReadValueId> {
        public ReadContext(OpcUaServer server, @Nullable Session session) {
            super(server, session);
        }

        public ReadContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<ReadValueId> diagnosticsContext, @Nullable String auditEntryId, UInteger timeoutHint, ExtensionObject additionalHeader) {
            super(server, session, diagnosticsContext, auditEntryId, timeoutHint, additionalHeader);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ReferenceResult {
        public static ReferenceList of(List<Reference> references) {
            return new ReferenceList(references);
        }

        public static BadNodeIdUnknown unknown() {
            return new BadNodeIdUnknown();
        }

        public record ReferenceList(List<Reference> references) implements ReferenceResult
        {
        }

        public record BadNodeIdUnknown() implements ReferenceResult
        {
        }
    }
}

