/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;

public abstract class AbstractLifecycle
implements Lifecycle {
    private final AtomicReference<LifecycleState> state = new AtomicReference<LifecycleState>(LifecycleState.NEW);

    @Override
    public final void startup() throws IllegalStateException {
        LifecycleState previous = this.state.getAndUpdate(prev -> prev == LifecycleState.NEW ? LifecycleState.RUNNING : prev);
        if (previous != LifecycleState.NEW) {
            throw new IllegalStateException("cannot call startup when state=" + String.valueOf((Object)previous));
        }
        this.onStartup();
    }

    @Override
    public final void shutdown() throws IllegalStateException {
        LifecycleState previous = this.state.getAndUpdate(prev -> prev == LifecycleState.RUNNING ? LifecycleState.STOPPED : prev);
        if (previous == LifecycleState.RUNNING) {
            this.onShutdown();
        } else if (previous == LifecycleState.NEW) {
            throw new IllegalStateException("Cannot call shutdown, never started.");
        }
    }

    public final boolean isRunning() {
        return this.state.get() == LifecycleState.RUNNING;
    }

    public final boolean isNotRunning() {
        return !this.isRunning();
    }

    protected abstract void onStartup();

    protected abstract void onShutdown();

    private static enum LifecycleState {
        NEW,
        RUNNING,
        STOPPED;

    }
}

