/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.util.PendingRead;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.shaded.com.google.common.math.DoubleMath;

public class SubscriptionModel
extends AbstractLifecycle {
    private final Set<DataItem> itemSet = ConcurrentHashMap.newKeySet();
    private final List<ScheduledUpdate> schedule = new CopyOnWriteArrayList<ScheduledUpdate>();
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final ExecutionQueue executionQueue;
    private final OpcUaServer server;
    private final AddressSpace addressSpace;

    public SubscriptionModel(OpcUaServer server, AddressSpace addressSpace) {
        this.server = server;
        this.addressSpace = addressSpace;
        this.executor = server.getExecutorService();
        this.scheduler = server.getScheduledExecutorService();
        this.executionQueue = new ExecutionQueue((Executor)this.executor);
    }

    @Override
    protected void onStartup() {
    }

    @Override
    protected void onShutdown() {
        this.executionQueue.submit(() -> {
            this.schedule.forEach(ScheduledUpdate::cancel);
            this.schedule.clear();
            this.itemSet.clear();
        });
    }

    public void onDataItemsCreated(List<DataItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(() -> {
            this.itemSet.addAll(items);
            this.reschedule();
        });
    }

    public void onDataItemsModified(List<DataItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(this::reschedule);
    }

    public void onDataItemsDeleted(List<DataItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(() -> {
            items.forEach(this.itemSet::remove);
            this.reschedule();
        });
    }

    public void onMonitoringModeChanged(List<MonitoredItem> items) {
        if (this.isNotRunning()) {
            throw new IllegalArgumentException("not running");
        }
        this.executionQueue.submit(this::reschedule);
    }

    public List<DataItem> getDataItems() {
        return List.copyOf(this.itemSet);
    }

    private void reschedule() {
        Map<Double, List<DataItem>> bySamplingInterval = this.itemSet.stream().filter(MonitoredItem::isSamplingEnabled).collect(Collectors.groupingBy(DataItem::getSamplingInterval));
        List<ScheduledUpdate> updates = bySamplingInterval.keySet().stream().map(samplingInterval -> {
            List items = (List)bySamplingInterval.get(samplingInterval);
            return new ScheduledUpdate((double)samplingInterval, items);
        }).toList();
        this.schedule.forEach(ScheduledUpdate::cancel);
        this.schedule.clear();
        this.schedule.addAll(updates);
        this.schedule.forEach(this.executor::execute);
    }

    private class ScheduledUpdate
    implements Runnable {
        private volatile boolean cancelled = false;
        private final long samplingInterval;
        private final List<DataItem> items;

        private ScheduledUpdate(double samplingInterval, List<DataItem> items) {
            this.samplingInterval = DoubleMath.roundToLong((double)samplingInterval, (RoundingMode)RoundingMode.UP);
            this.items = items;
        }

        private void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            List values = GroupMapCollate.groupMapCollate(this.items, MonitoredItem::getSession, session -> sessionItems -> {
                List<PendingRead> pending = sessionItems.stream().map(item -> new PendingRead(item.getReadValueId())).toList();
                List<ReadValueId> ids = pending.stream().map(PendingRead::getInput).collect(Collectors.toList());
                AddressSpace.ReadContext context = new AddressSpace.ReadContext(SubscriptionModel.this.server, (Session)session);
                return SubscriptionModel.this.addressSpace.read(context, 0.0, TimestampsToReturn.Both, ids);
            });
            Iterator<DataItem> ii = this.items.iterator();
            Iterator vi = values.iterator();
            while (ii.hasNext() && vi.hasNext()) {
                DataItem item = ii.next();
                DataValue value = (DataValue)vi.next();
                TimestampsToReturn timestamps = item.getTimestampsToReturn();
                if (timestamps != null) {
                    UInteger attributeId = item.getReadValueId().getAttributeId();
                    value = AttributeId.Value.isEqual(attributeId) ? DataValue.derivedValue((DataValue)value, (TimestampsToReturn)timestamps) : DataValue.derivedNonValue((DataValue)value, (TimestampsToReturn)timestamps);
                }
                item.setValue(value);
            }
            if (!this.cancelled) {
                SubscriptionModel.this.scheduler.schedule(() -> SubscriptionModel.this.executor.execute(this), this.samplingInterval, TimeUnit.MILLISECONDS);
            }
        }
    }
}

