/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.subscriptions;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishQueue {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedList<PendingPublish> pendingQueue = new LinkedList();
    private final LinkedHashMap<UInteger, WaitingSubscription> waitList = new LinkedHashMap();
    private final ExecutorService executor;

    public PublishQueue(ExecutorService executor) {
        this.executor = executor;
    }

    public synchronized void addRequest(PendingPublish pending) {
        List<WaitingSubscription> waitingSubscriptions = List.copyOf(this.waitList.values());
        if (waitingSubscriptions.isEmpty()) {
            this.pendingQueue.add(pending);
            this.logger.debug("Queued PublishRequest requestHandle={}, size={}", (Object)pending.request.getRequestHeader().getRequestHandle(), (Object)this.pendingQueue.size());
        } else {
            this.logger.debug("{} subscriptions waiting", (Object)waitingSubscriptions.size());
            WaitingSubscription subscription = null;
            int maxPriority = 0;
            long minWaitingSince = Long.MAX_VALUE;
            for (WaitingSubscription waiting : waitingSubscriptions) {
                int priority = waiting.getSubscription().getPriority();
                long waitingSince = waiting.getWaitingSince().getTime();
                this.logger.debug("subscription id={} priority={} waitingSince={}", new Object[]{waiting.getSubscription().getId(), priority, waitingSince});
                if (priority > maxPriority) {
                    maxPriority = priority;
                    minWaitingSince = Long.MAX_VALUE;
                }
                if (priority < maxPriority || waitingSince >= minWaitingSince) continue;
                minWaitingSince = waitingSince;
                subscription = waiting;
                this.logger.debug("subscription id={} priority={} now next in line", (Object)waiting.getSubscription().getId(), (Object)priority);
            }
            if (subscription != null) {
                this.waitList.remove(subscription.subscription.getId());
                this.logger.debug("delivering PublishRequest to subscription id={} priority={}", (Object)subscription.getSubscription().getId(), (Object)subscription.getSubscription().getPriority());
                WaitingSubscription ws = subscription;
                this.executor.execute(() -> ws.subscription.onPublish(pending));
            } else {
                this.pendingQueue.add(pending);
            }
        }
    }

    public synchronized void addSubscription(Subscription subscription) {
        if (this.waitList.isEmpty() && !this.pendingQueue.isEmpty()) {
            PendingPublish pending = this.poll();
            if (pending != null) {
                this.executor.execute(() -> subscription.onPublish(pending));
            } else {
                this.waitList.putIfAbsent(subscription.getId(), new WaitingSubscription(subscription));
            }
        } else {
            this.waitList.putIfAbsent(subscription.getId(), new WaitingSubscription(subscription));
        }
    }

    public synchronized boolean isEmpty() {
        return this.pendingQueue.isEmpty();
    }

    public synchronized boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public synchronized boolean isWaitListEmpty() {
        return this.waitList.isEmpty();
    }

    public synchronized @Nullable PendingPublish poll() {
        long nowNanos = System.nanoTime();
        PendingPublish pending;
        while ((pending = this.pendingQueue.poll()) != null) {
            RequestHeader requestHeader = pending.request.getRequestHeader();
            long millisSinceReceived = TimeUnit.MILLISECONDS.convert(nowNanos - pending.context.receivedAtNanos(), TimeUnit.NANOSECONDS);
            long timeoutHint = requestHeader.getTimeoutHint().longValue();
            if (timeoutHint == 0L || millisSinceReceived < timeoutHint) {
                return pending;
            }
            this.logger.debug("Discarding expired PublishRequest requestHandle={} timestamp={} timeoutHint={}", new Object[]{pending.request.getRequestHeader().getRequestHandle(), requestHeader.getTimestamp().getJavaDate(), timeoutHint});
            pending.responseFuture.completeExceptionally(new UaException(0x800A0000L));
        }
        return null;
    }

    public synchronized int size() {
        return this.pendingQueue.size();
    }

    public static class PendingPublish {
        public final CompletableFuture<PublishResponse> responseFuture = new CompletableFuture();
        public final ServiceRequestContext context;
        public final PublishRequest request;
        public final StatusCode[] acknowledgeResults;

        public PendingPublish(ServiceRequestContext context, PublishRequest request, StatusCode[] acknowledgeResults) {
            this.context = context;
            this.request = request;
            this.acknowledgeResults = acknowledgeResults;
        }
    }

    public static class WaitingSubscription {
        private final Date waitingSince = new Date();
        private final Subscription subscription;

        public WaitingSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public Date getWaitingSince() {
            return this.waitingSince;
        }
    }
}

