/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.milo.opcua.sdk.core.util.GroupMapCollate;
import org.eclipse.milo.opcua.sdk.server.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.servicesets.AbstractServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.NodeManagementServiceSet;
import org.eclipse.milo.opcua.sdk.server.servicesets.impl.AccessController;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResult;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.Lists;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public class DefaultNodeManagementServiceSet
implements NodeManagementServiceSet {
    private final OpcUaServer server;

    public DefaultNodeManagementServiceSet(OpcUaServer server) {
        this.server = server;
    }

    @Override
    public AddNodesResponse onAddNodes(ServiceRequestContext context, AddNodesRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            AddNodesResponse addNodesResponse = this.addNodes(request, session);
            return addNodesResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getDeleteNodesCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getDeleteNodesCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public DeleteNodesResponse onDeleteNodes(ServiceRequestContext context, DeleteNodesRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            DeleteNodesResponse deleteNodesResponse = this.deleteNodes(request, session);
            return deleteNodesResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getDeleteNodesCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getDeleteNodesCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public AddReferencesResponse onAddReferences(ServiceRequestContext context, AddReferencesRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            AddReferencesResponse addReferencesResponse = this.addReferences(request, session);
            return addReferencesResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getAddReferencesCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getAddReferencesCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    @Override
    public DeleteReferencesResponse onDeleteReferences(ServiceRequestContext context, DeleteReferencesRequest request) throws UaException {
        Session session = this.server.getSessionManager().getSession(context, request.getRequestHeader());
        try {
            DeleteReferencesResponse deleteReferencesResponse = this.deleteReferences(request, session);
            return deleteReferencesResponse;
        }
        catch (UaException e) {
            session.getSessionDiagnostics().getDeleteReferencesCount().incrementErrorCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementErrorCount();
            throw e;
        }
        finally {
            session.getSessionDiagnostics().getDeleteReferencesCount().incrementTotalCount();
            session.getSessionDiagnostics().getTotalRequestCount().incrementTotalCount();
        }
    }

    private AddNodesResponse addNodes(AddNodesRequest request, Session session) throws UaException {
        List nodesToAdd = Lists.ofNullable((Object[])request.getNodesToAdd());
        if (nodesToAdd.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)nodesToAdd.size() > this.server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            throw new UaException(0x80100000L);
        }
        DiagnosticsContext<AddNodesItem> diagnosticsContext = new DiagnosticsContext<AddNodesItem>();
        AddressSpace.AddNodesContext addNodesContext = new AddressSpace.AddNodesContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
        List<AddNodesResult> results = this.server.getAddressSpaceManager().addNodes(addNodesContext, nodesToAdd);
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToAdd);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new AddNodesResponse(header, (AddNodesResult[])results.toArray(AddNodesResult[]::new), diagnosticInfos);
    }

    private DeleteNodesResponse deleteNodes(DeleteNodesRequest request, Session session) throws UaException {
        List nodesToDelete = Lists.ofNullable((Object[])request.getNodesToDelete());
        if (nodesToDelete.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)nodesToDelete.size() > this.server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            throw new UaException(0x80100000L);
        }
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        Map<DeleteNodesItem, AccessController.AccessResult> accessResults = this.server.getAccessController().checkDeleteNodesAccess(session, nodesToDelete);
        List results = GroupMapCollate.groupMapCollate((List)nodesToDelete, accessResults::get, accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                return Collections.nCopies(group.size(), denied.statusCode());
            }
            AddressSpace.DeleteNodesContext deleteNodesContext = new AddressSpace.DeleteNodesContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
            return this.server.getAddressSpaceManager().deleteNodes(deleteNodesContext, (List<DeleteNodesItem>)group);
        });
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToDelete);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new DeleteNodesResponse(header, (StatusCode[])results.toArray(StatusCode[]::new), diagnosticInfos);
    }

    private AddReferencesResponse addReferences(AddReferencesRequest request, Session session) throws UaException {
        List referencesToAdd = Lists.ofNullable((Object[])request.getReferencesToAdd());
        if (referencesToAdd.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)referencesToAdd.size() > this.server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            throw new UaException(0x80100000L);
        }
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        Map<AddReferencesItem, AccessController.AccessResult> accessResults = this.server.getAccessController().checkAddReferencesAccess(session, referencesToAdd);
        List results = GroupMapCollate.groupMapCollate((List)referencesToAdd, accessResults::get, accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                return Collections.nCopies(group.size(), denied.statusCode());
            }
            AddressSpace.AddReferencesContext addReferencesContext = new AddressSpace.AddReferencesContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
            return this.server.getAddressSpaceManager().addReferences(addReferencesContext, (List<AddReferencesItem>)group);
        });
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(referencesToAdd);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new AddReferencesResponse(header, results.toArray(new StatusCode[0]), diagnosticInfos);
    }

    private DeleteReferencesResponse deleteReferences(DeleteReferencesRequest request, Session session) throws UaException {
        List referencesToDelete = Lists.ofNullable((Object[])request.getReferencesToDelete());
        if (referencesToDelete.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        if ((long)referencesToDelete.size() > this.server.getConfig().getLimits().getMaxNodesPerNodeManagement().longValue()) {
            throw new UaException(0x80100000L);
        }
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        Map<DeleteReferencesItem, AccessController.AccessResult> accessResults = this.server.getAccessController().checkDeleteReferencesAccess(session, referencesToDelete);
        List results = GroupMapCollate.groupMapCollate((List)referencesToDelete, accessResults::get, accessResult -> group -> {
            if (accessResult instanceof AccessController.AccessResult.Denied) {
                AccessController.AccessResult.Denied denied = (AccessController.AccessResult.Denied)accessResult;
                return Collections.nCopies(group.size(), denied.statusCode());
            }
            AddressSpace.DeleteReferencesContext deleteReferencesContext = new AddressSpace.DeleteReferencesContext(this.server, session, diagnosticsContext, request.getRequestHeader().getAuditEntryId(), request.getRequestHeader().getTimeoutHint(), request.getRequestHeader().getAdditionalHeader());
            return this.server.getAddressSpaceManager().deleteReferences(deleteReferencesContext, (List<DeleteReferencesItem>)group);
        });
        DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(referencesToDelete);
        ResponseHeader header = AbstractServiceSet.createResponseHeader((UaRequestMessageType)request);
        return new DeleteReferencesResponse(header, (StatusCode[])results.toArray(StatusCode[]::new), diagnosticInfos);
    }
}

