/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.servicesets.impl;

import java.util.List;
import java.util.Map;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public interface AccessController {
    public Map<ReadValueId, AccessResult> checkReadAccess(Session var1, List<ReadValueId> var2);

    public Map<WriteValue, AccessResult> checkWriteAccess(Session var1, List<WriteValue> var2);

    public Map<NodeId, AccessResult> checkBrowseAccess(Session var1, List<NodeId> var2);

    public Map<CallMethodRequest, AccessResult> checkCallAccess(Session var1, List<CallMethodRequest> var2);

    public Map<AddReferencesItem, AccessResult> checkAddReferencesAccess(Session var1, List<AddReferencesItem> var2);

    public Map<DeleteNodesItem, AccessResult> checkDeleteNodesAccess(Session var1, List<DeleteNodesItem> var2);

    public Map<DeleteReferencesItem, AccessResult> checkDeleteReferencesAccess(Session var1, List<DeleteReferencesItem> var2);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface AccessResult {
        public static final AccessResult ALLOWED = new Allowed();
        public static final AccessResult DENIED_USER_ACCESS = new Denied(2149515264L);
        public static final AccessResult DENIED_SECURITY_MODE = new Denied(2162556928L);

        default public boolean isAllowed() {
            return this instanceof Allowed;
        }

        default public boolean isDenied() {
            return this instanceof Denied;
        }

        public record Allowed() implements AccessResult
        {
        }

        public record Denied(StatusCode statusCode) implements AccessResult
        {
            public Denied(long code) {
                this(new StatusCode(code));
            }
        }
    }
}

