/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.core.nodes.ReferenceTypeNodeProperties;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.jspecify.annotations.Nullable;

public class UaReferenceTypeNode
extends UaNode
implements ReferenceTypeNode {
    private Boolean isAbstract;
    private Boolean symmetric;
    private @Nullable LocalizedText inverseName;

    public UaReferenceTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract, Boolean symmetric, @Nullable LocalizedText inverseName) {
        super(context, nodeId, NodeClass.ReferenceType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    public UaReferenceTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, Boolean isAbstract, Boolean symmetric, @Nullable LocalizedText inverseName) {
        super(context, nodeId, NodeClass.ReferenceType, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    public Boolean getIsAbstract() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.IsAbstract);
    }

    public Boolean getSymmetric() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.Symmetric);
    }

    public @Nullable LocalizedText getInverseName() {
        return (LocalizedText)this.filterChain.getAttribute(this, AttributeId.InverseName);
    }

    public void setIsAbstract(Boolean isAbstract) {
        this.filterChain.setAttribute(this, AttributeId.IsAbstract, isAbstract);
    }

    public void setSymmetric(Boolean symmetric) {
        this.filterChain.setAttribute(this, AttributeId.Symmetric, symmetric);
    }

    public void setInverseName(LocalizedText inverseName) {
        this.filterChain.setAttribute(this, AttributeId.InverseName, inverseName);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        return switch (attributeId) {
            case AttributeId.IsAbstract -> this.isAbstract;
            case AttributeId.Symmetric -> this.symmetric;
            case AttributeId.InverseName -> this.inverseName;
            default -> super.getAttribute(attributeId);
        };
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case IsAbstract: {
                this.isAbstract = (Boolean)value;
                break;
            }
            case Symmetric: {
                this.symmetric = (Boolean)value;
                break;
            }
            case InverseName: {
                this.inverseName = (LocalizedText)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public @Nullable String getNodeVersion() {
        return this.getProperty(ReferenceTypeNodeProperties.NodeVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(ReferenceTypeNodeProperties.NodeVersion, nodeVersion);
    }
}

