/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.server.EventListener;
import org.eclipse.milo.opcua.sdk.server.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.items.DataItem;
import org.eclipse.milo.opcua.sdk.server.items.EventItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.server.model.objects.OperationLimitsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerCapabilitiesTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerType;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.ServerStatusTypeNode;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.NodeLoader;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.RedundancySupport;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaNamespace
extends ManagedNamespaceWithLifecycle {
    private static final double MIN_SAMPLING_INTERVAL = 100.0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServer server;

    public OpcUaNamespace(OpcUaServer server) {
        super(server, "http://opcfoundation.org/UA/");
        this.server = server;
        this.subscriptionModel = new SubscriptionModel(server, this);
        this.getLifecycleManager().addStartupTask(() -> {
            this.loadNodes();
            this.configureServerObject();
            this.configureConditionRefresh();
            this.getNodeManager().getNodes().stream().filter(node -> node instanceof UaVariableNode).map(UaVariableNode.class::cast).forEach(n -> n.setMinimumSamplingInterval(100.0));
        });
        this.getLifecycleManager().addLifecycle(this.subscriptionModel);
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    @Override
    public void onEventItemsCreated(List<EventItem> eventItems) {
        eventItems.stream().filter(MonitoredItem::isSamplingEnabled).forEach(item -> this.server.getEventNotifier().register((EventListener)item));
    }

    @Override
    public void onEventItemsModified(List<EventItem> eventItems) {
        for (EventItem item : eventItems) {
            if (item.isSamplingEnabled()) {
                this.server.getEventNotifier().register(item);
                continue;
            }
            this.server.getEventNotifier().unregister(item);
        }
    }

    @Override
    public void onEventItemsDeleted(List<EventItem> eventItems) {
        eventItems.forEach(item -> this.server.getEventNotifier().unregister((EventListener)item));
    }

    private void loadNodes() {
        try {
            long startTime = System.nanoTime();
            long startCount = this.getNodeManager().getNodes().size();
            new NodeLoader(this.getNodeContext(), this.getNodeManager()).loadNodes();
            long deltaMs = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            long deltaCount = (long)this.getNodeManager().getNodes().size() - startCount;
            this.logger.debug("Loaded {} nodes in {}ms.", (Object)deltaCount, (Object)deltaMs);
        }
        catch (Exception e) {
            this.logger.error("Error loading nodes.", (Throwable)e);
        }
    }

    private void configureServerObject() {
        ServerTypeNode serverTypeNode = (ServerTypeNode)this.getNodeManager().get(NodeIds.Server);
        assert (serverTypeNode != null);
        serverTypeNode.getNamespaceArrayNode().getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)this.server.getNamespaceTable().toArray()))));
        serverTypeNode.getServerArrayNode().getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)this.server.getServerTable().toArray()))));
        serverTypeNode.setAuditing(false);
        serverTypeNode.getServerDiagnosticsNode().setEnabledFlag(false);
        serverTypeNode.setServiceLevel(Unsigned.ubyte((int)255));
        serverTypeNode.setEstimatedReturnTime(DateTime.now());
        ServerStatusTypeNode serverStatus = serverTypeNode.getServerStatusNode();
        BuildInfo buildInfo = this.server.getConfig().getBuildInfo();
        serverStatus.setBuildInfo(buildInfo);
        serverStatus.getBuildInfoNode().setBuildDate(buildInfo.getBuildDate());
        serverStatus.getBuildInfoNode().setBuildNumber(buildInfo.getBuildNumber());
        serverStatus.getBuildInfoNode().setManufacturerName(buildInfo.getManufacturerName());
        serverStatus.getBuildInfoNode().setProductName(buildInfo.getProductName());
        serverStatus.getBuildInfoNode().setProductUri(buildInfo.getProductUri());
        serverStatus.getBuildInfoNode().setSoftwareVersion(buildInfo.getSoftwareVersion());
        serverStatus.setCurrentTime(DateTime.now());
        serverStatus.setSecondsTillShutdown(Unsigned.uint((int)0));
        serverStatus.setShutdownReason(LocalizedText.NULL_VALUE);
        serverStatus.setState(ServerState.Running);
        serverStatus.setStartTime(DateTime.now());
        serverStatus.getCurrentTimeNode().getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)DateTime.now()))));
        serverStatus.getFilterChain().addLast(AttributeFilters.getValue(ctx -> {
            ServerStatusTypeNode serverStatusNode = (ServerStatusTypeNode)ctx.getNode();
            ExtensionObject xo = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)new ServerStatusDataType(serverStatusNode.getStartTime(), DateTime.now(), serverStatusNode.getState(), serverStatusNode.getBuildInfo(), serverStatusNode.getSecondsTillShutdown(), serverStatusNode.getShutdownReason()));
            return new DataValue(new Variant((Object)xo));
        }));
        OpcUaServerConfigLimits limits = this.server.getConfig().getLimits();
        ServerCapabilitiesTypeNode serverCapabilities = serverTypeNode.getServerCapabilitiesNode();
        serverCapabilities.setServerProfileArray(new String[]{"http://opcfoundation.org/UA-Profile/Server/StandardUA"});
        serverCapabilities.setLocaleIdArray(new String[]{Locale.ENGLISH.getLanguage()});
        serverCapabilities.setMaxArrayLength(limits.getMaxArrayLength());
        serverCapabilities.setMaxStringLength(limits.getMaxStringLength());
        serverCapabilities.setMaxByteStringLength(limits.getMaxByteStringLength());
        serverCapabilities.setMaxBrowseContinuationPoints(limits.getMaxBrowseContinuationPoints());
        serverCapabilities.setMaxHistoryContinuationPoints(limits.getMaxHistoryContinuationPoints());
        serverCapabilities.setMaxQueryContinuationPoints(limits.getMaxQueryContinuationPoints());
        serverCapabilities.setMinSupportedSampleRate(limits.getMinSupportedSampleRate());
        serverCapabilities.setMaxSessions(limits.getMaxSessions());
        serverCapabilities.setMaxSubscriptions(limits.getMaxSubscriptions());
        serverCapabilities.setMaxSubscriptionsPerSession(limits.getMaxSubscriptionsPerSession());
        serverCapabilities.setMaxMonitoredItems(limits.getMaxMonitoredItems());
        serverCapabilities.getMaxMonitoredItemsPerSubscriptionNode().delete();
        serverCapabilities.getRoleSetNode().delete();
        serverCapabilities.getMaxSelectClauseParametersNode().delete();
        serverCapabilities.getMaxWhereClauseParametersNode().delete();
        serverCapabilities.getConformanceUnitsNode().delete();
        OperationLimitsTypeNode limitsNode = serverCapabilities.getOperationLimitsNode();
        limitsNode.setMaxMonitoredItemsPerCall(limits.getMaxMonitoredItemsPerCall());
        limitsNode.setMaxNodesPerBrowse(limits.getMaxNodesPerBrowse());
        limitsNode.setMaxNodesPerHistoryReadData(limits.getMaxNodesPerHistoryReadData());
        limitsNode.setMaxNodesPerHistoryReadEvents(limits.getMaxNodesPerHistoryReadEvents());
        limitsNode.setMaxNodesPerHistoryUpdateData(limits.getMaxNodesPerHistoryUpdateData());
        limitsNode.setMaxNodesPerHistoryUpdateEvents(limits.getMaxNodesPerHistoryUpdateEvents());
        limitsNode.setMaxNodesPerMethodCall(limits.getMaxNodesPerMethodCall());
        limitsNode.setMaxNodesPerNodeManagement(limits.getMaxNodesPerNodeManagement());
        limitsNode.setMaxNodesPerRead(limits.getMaxNodesPerRead());
        limitsNode.setMaxNodesPerRegisterNodes(limits.getMaxNodesPerRegisterNodes());
        limitsNode.setMaxNodesPerTranslateBrowsePathsToNodeIds(limits.getMaxNodesPerTranslateBrowsePathsToNodeIds());
        limitsNode.setMaxNodesPerWrite(limits.getMaxNodesPerWrite());
        serverTypeNode.getServerRedundancyNode().setRedundancySupport(RedundancySupport.None);
        this.configureGetMonitoredItems();
        this.configureResendData();
    }

    private void configureGetMonitoredItems() {
        UaNode node = (UaNode)this.getNodeManager().get(NodeIds.Server_GetMonitoredItems);
        if (node instanceof UaMethodNode) {
            UaMethodNode methodNode = (UaMethodNode)node;
            OpcUaNamespace.configureMethodNode(methodNode, GetMonitoredItemsMethodImpl::new);
        } else {
            this.logger.warn("GetMonitoredItems UaMethodNode not found.");
        }
    }

    private void configureResendData() {
        UaNode node = (UaNode)this.getNodeManager().get(NodeIds.Server_ResendData);
        if (node instanceof UaMethodNode) {
            UaMethodNode resendDataNode = (UaMethodNode)node;
            OpcUaNamespace.configureMethodNode(resendDataNode, ResendDataMethodImpl::new);
        } else {
            this.logger.warn("ResendData UaMethodNode not found.");
        }
    }

    private void configureConditionRefresh() {
        UaNode node = (UaNode)this.getNodeManager().get(NodeIds.ConditionType_ConditionRefresh);
        if (node instanceof UaMethodNode) {
            UaMethodNode conditionRefreshNode = (UaMethodNode)node;
            OpcUaNamespace.configureMethodNode(conditionRefreshNode, ConditionRefreshMethodImpl::new);
        } else {
            this.logger.warn("ConditionRefresh UaMethodNode not found.");
        }
    }

    private static <T extends AbstractMethodInvocationHandler> void configureMethodNode(UaMethodNode methodNode, Function<UaMethodNode, T> f) {
        AbstractMethodInvocationHandler invocationHandler = (AbstractMethodInvocationHandler)f.apply(methodNode);
        Argument[] inputArguments = invocationHandler.getInputArguments();
        Argument[] outputArguments = invocationHandler.getOutputArguments();
        methodNode.setInvocationHandler(invocationHandler);
        if (inputArguments != null && inputArguments.length > 0) {
            methodNode.setInputArguments(inputArguments);
        }
        if (outputArguments != null && outputArguments.length > 0) {
            methodNode.setOutputArguments(outputArguments);
        }
    }

    private static class ResendDataMethodImpl
    extends ServerType.ResendDataMethod {
        ResendDataMethodImpl(UaMethodNode node) {
            super(node);
        }

        @Override
        protected void invoke(AbstractMethodInvocationHandler.InvocationContext context, UInteger subscriptionId) throws UaException {
            Subscription subscription;
            Session session = context.getSession().orElse(null);
            if (session != null) {
                subscription = session.getSubscriptionManager().getSubscription(subscriptionId);
                if (subscription == null) {
                    if (session.getServer().getSubscriptions().containsKey(subscriptionId)) {
                        throw new UaException(2149515264L);
                    }
                    throw new UaException(0x80280000L);
                }
            } else {
                throw new UaException(2149515264L);
            }
            subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::maybeSendLastValue);
        }
    }

    private static class GetMonitoredItemsMethodImpl
    extends ServerType.GetMonitoredItemsMethod {
        private final OpcUaServer server;

        GetMonitoredItemsMethodImpl(UaMethodNode node) {
            super(node);
            this.server = node.getNodeContext().getServer();
        }

        @Override
        protected void invoke(AbstractMethodInvocationHandler.InvocationContext context, UInteger subscriptionId, Out<UInteger[]> serverHandles, Out<UInteger[]> clientHandles) throws UaException {
            Session session = context.getSession().orElseThrow(() -> new UaException(2149908480L));
            Subscription subscription = this.server.getSubscriptions().get(subscriptionId);
            if (subscription == null) {
                throw new UaException(0x80280000L);
            }
            if (!session.getSessionId().equals((Object)subscription.getSession().getSessionId())) {
                throw new UaException(2149515264L);
            }
            ArrayList<UInteger> serverHandleList = new ArrayList<UInteger>();
            ArrayList<UInteger> clientHandleList = new ArrayList<UInteger>();
            for (BaseMonitoredItem<?> item : subscription.getMonitoredItems().values()) {
                serverHandleList.add(item.getId());
                clientHandleList.add(Unsigned.uint((long)item.getClientHandle()));
            }
            serverHandles.set(serverHandleList.toArray(new UInteger[0]));
            clientHandles.set(clientHandleList.toArray(new UInteger[0]));
        }
    }

    private static class ConditionRefreshMethodImpl
    extends ConditionType.ConditionRefreshMethod {
        private final OpcUaServer server;

        ConditionRefreshMethodImpl(UaMethodNode node) {
            super(node);
            this.server = node.getNodeContext().getServer();
        }

        @Override
        protected void invoke(AbstractMethodInvocationHandler.InvocationContext context, UInteger subscriptionId) throws UaException {
            Session session = context.getSession().orElse(null);
            if (session != null) {
                Subscription subscription = session.getSubscriptionManager().getSubscription(subscriptionId);
                if (subscription == null) {
                    throw new UaException(0x80280000L);
                }
            } else {
                throw new UaException(2149515264L);
            }
            BaseEventTypeNode refreshStart = this.server.getEventFactory().createEvent(new NodeId(1, UUID.randomUUID()), NodeIds.RefreshStartEventType);
            refreshStart.setBrowseName(new QualifiedName(1, "RefreshStart"));
            refreshStart.setDisplayName(LocalizedText.english((String)"RefreshStart"));
            refreshStart.setEventId(NonceUtil.generateNonce((int)16));
            refreshStart.setEventType(NodeIds.RefreshStartEventType);
            refreshStart.setSourceNode(NodeIds.Server);
            refreshStart.setSourceName("Server");
            refreshStart.setTime(DateTime.now());
            refreshStart.setReceiveTime(DateTime.NULL_VALUE);
            refreshStart.setMessage(LocalizedText.english((String)"RefreshStart"));
            refreshStart.setSeverity(Unsigned.ushort((int)0));
            BaseEventTypeNode refreshEnd = this.server.getEventFactory().createEvent(new NodeId(1, UUID.randomUUID()), NodeIds.RefreshEndEventType);
            refreshEnd.setBrowseName(new QualifiedName(1, "RefreshEnd"));
            refreshEnd.setDisplayName(LocalizedText.english((String)"RefreshEnd"));
            refreshEnd.setEventId(NonceUtil.generateNonce((int)16));
            refreshEnd.setEventType(NodeIds.RefreshEndEventType);
            refreshEnd.setSourceNode(NodeIds.Server);
            refreshEnd.setSourceName("Server");
            refreshEnd.setTime(DateTime.now());
            refreshEnd.setReceiveTime(DateTime.NULL_VALUE);
            refreshEnd.setMessage(LocalizedText.english((String)"RefreshEnd"));
            refreshEnd.setSeverity(Unsigned.ushort((int)0));
            this.server.getEventNotifier().fire(refreshStart);
            this.server.getEventNotifier().fire(refreshEnd);
            refreshStart.delete();
            refreshEnd.delete();
        }
    }
}

