/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface TemporaryFileTransferType
extends BaseObjectType {
    public static final QualifiedProperty<Double> CLIENT_PROCESSING_TIMEOUT = new QualifiedProperty("http://opcfoundation.org/UA/", "ClientProcessingTimeout", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290"), Integer.valueOf(-1), Double.class);

    public Double getClientProcessingTimeout();

    public void setClientProcessingTimeout(Double var1);

    public PropertyType getClientProcessingTimeoutNode();

    public MethodNode getGenerateFileForReadMethodNode();

    public MethodNode getGenerateFileForWriteMethodNode();

    public MethodNode getCloseAndCommitMethodNode();

    public static abstract class CloseAndCommitMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public CloseAndCommitMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("CompletionStateMachine", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger fileHandle = (UInteger)inputValues[0].getValue();
            Out<NodeId> completionStateMachine = new Out<NodeId>();
            this.invoke(context, fileHandle, completionStateMachine);
            return new Variant[]{new Variant((Object)completionStateMachine.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, Out<NodeId> var3) throws UaException;
    }

    public static abstract class GenerateFileForWriteMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GenerateFileForWriteMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("GenerateOptions", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            Object generateOptions = inputValues[0].getValue();
            Out<NodeId> fileNodeId = new Out<NodeId>();
            Out<UInteger> fileHandle = new Out<UInteger>();
            this.invoke(context, generateOptions, fileNodeId, fileHandle);
            return new Variant[]{new Variant((Object)fileNodeId.get()), new Variant((Object)fileHandle.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, Object var2, Out<NodeId> var3, Out<UInteger> var4) throws UaException;
    }

    public static abstract class GenerateFileForReadMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public GenerateFileForReadMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("GenerateOptions", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("FileNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FileHandle", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=7").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CompletionStateMachine", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            Object generateOptions = inputValues[0].getValue();
            Out<NodeId> fileNodeId = new Out<NodeId>();
            Out<UInteger> fileHandle = new Out<UInteger>();
            Out<NodeId> completionStateMachine = new Out<NodeId>();
            this.invoke(context, generateOptions, fileNodeId, fileHandle, completionStateMachine);
            return new Variant[]{new Variant((Object)fileNodeId.get()), new Variant((Object)fileHandle.get()), new Variant((Object)completionStateMachine.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, Object var2, Out<NodeId> var3, Out<UInteger> var4, Out<NodeId> var5) throws UaException;
    }
}

