/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.DataSetFolderType;
import org.eclipse.milo.opcua.sdk.server.model.objects.FolderType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubCapabilitiesType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubConfigurationType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubDiagnosticsRootType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubKeyServiceType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubStatusType;
import org.eclipse.milo.opcua.sdk.server.model.objects.SubscribedDataSetFolderType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.PubSubConnectionDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface PublishSubscribeType
extends PubSubKeyServiceType {
    public static final QualifiedProperty<String[]> SUPPORTED_TRANSPORT_PROFILES = new QualifiedProperty("http://opcfoundation.org/UA/", "SupportedTransportProfiles", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(1), String[].class);
    public static final QualifiedProperty<ULong> DEFAULT_DATAGRAM_PUBLISHER_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "DefaultDatagramPublisherId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=9"), Integer.valueOf(-1), ULong.class);
    public static final QualifiedProperty<UInteger> CONFIGURATION_VERSION = new QualifiedProperty("http://opcfoundation.org/UA/", "ConfigurationVersion", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=20998"), Integer.valueOf(-1), UInteger.class);
    public static final QualifiedProperty<EndpointDescription[]> DEFAULT_SECURITY_KEY_SERVICES = new QualifiedProperty("http://opcfoundation.org/UA/", "DefaultSecurityKeyServices", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=312"), Integer.valueOf(1), EndpointDescription[].class);
    public static final QualifiedProperty<KeyValuePair[]> CONFIGURATION_PROPERTIES = new QualifiedProperty("http://opcfoundation.org/UA/", "ConfigurationProperties", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14533"), Integer.valueOf(1), KeyValuePair[].class);

    public String[] getSupportedTransportProfiles();

    public void setSupportedTransportProfiles(String[] var1);

    public PropertyType getSupportedTransportProfilesNode();

    public ULong getDefaultDatagramPublisherId();

    public void setDefaultDatagramPublisherId(ULong var1);

    public PropertyType getDefaultDatagramPublisherIdNode();

    public UInteger getConfigurationVersion();

    public void setConfigurationVersion(UInteger var1);

    public PropertyType getConfigurationVersionNode();

    public EndpointDescription[] getDefaultSecurityKeyServices();

    public void setDefaultSecurityKeyServices(EndpointDescription[] var1);

    public PropertyType getDefaultSecurityKeyServicesNode();

    public KeyValuePair[] getConfigurationProperties();

    public void setConfigurationProperties(KeyValuePair[] var1);

    public PropertyType getConfigurationPropertiesNode();

    public MethodNode getSetSecurityKeysMethodNode();

    public MethodNode getAddConnectionMethodNode();

    public MethodNode getRemoveConnectionMethodNode();

    public DataSetFolderType getPublishedDataSetsNode();

    public SubscribedDataSetFolderType getSubscribedDataSetsNode();

    public PubSubConfigurationType getPubSubConfigurationNode();

    public PubSubStatusType getStatusNode();

    public PubSubDiagnosticsRootType getDiagnosticsNode();

    public PubSubCapabilitiesType getPubSubCapablitiesNode();

    public FolderType getDataSetClassesNode();

    public static abstract class RemoveConnectionMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveConnectionMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConnectionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId connectionId = (NodeId)inputValues[0].getValue();
            this.invoke(context, connectionId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2) throws UaException;
    }

    public static abstract class AddConnectionMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddConnectionMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Configuration", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15617").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConnectionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            PubSubConnectionDataType configuration = (PubSubConnectionDataType)inputValues[0].getValue();
            Out<NodeId> connectionId = new Out<NodeId>();
            this.invoke(context, configuration, connectionId);
            return new Variant[]{new Variant((Object)connectionId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, PubSubConnectionDataType var2, Out<NodeId> var3) throws UaException;
    }

    public static abstract class SetSecurityKeysMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public SetSecurityKeysMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SecurityGroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("SecurityPolicyUri", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CurrentTokenId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=288").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("CurrentKey", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FutureKeys", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("TimeToNextKey", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("KeyLifetime", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=290").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String securityGroupId = (String)inputValues[0].getValue();
            String securityPolicyUri = (String)inputValues[1].getValue();
            UInteger currentTokenId = (UInteger)inputValues[2].getValue();
            ByteString currentKey = (ByteString)inputValues[3].getValue();
            ByteString[] futureKeys = (ByteString[])inputValues[4].getValue();
            Double timeToNextKey = (Double)inputValues[5].getValue();
            Double keyLifetime = (Double)inputValues[6].getValue();
            this.invoke(context, securityGroupId, securityPolicyUri, currentTokenId, currentKey, futureKeys, timeToNextKey, keyLifetime);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, String var3, UInteger var4, ByteString var5, ByteString[] var6, Double var7, Double var8) throws UaException;
    }
}

