/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseObjectType;
import org.eclipse.milo.opcua.sdk.server.model.objects.ConnectionTransportType;
import org.eclipse.milo.opcua.sdk.server.model.objects.NetworkAddressType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubDiagnosticsConnectionType;
import org.eclipse.milo.opcua.sdk.server.model.objects.PubSubStatusType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.model.variables.SelectionListType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.ReaderGroupDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.WriterGroupDataType;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface PubSubConnectionType
extends BaseObjectType {
    public static final QualifiedProperty<Object> PUBLISHER_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "PublisherId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=24"), Integer.valueOf(-1), Object.class);
    public static final QualifiedProperty<KeyValuePair[]> CONNECTION_PROPERTIES = new QualifiedProperty("http://opcfoundation.org/UA/", "ConnectionProperties", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14533"), Integer.valueOf(1), KeyValuePair[].class);

    public Object getPublisherId();

    public void setPublisherId(Object var1);

    public PropertyType getPublisherIdNode();

    public KeyValuePair[] getConnectionProperties();

    public void setConnectionProperties(KeyValuePair[] var1);

    public PropertyType getConnectionPropertiesNode();

    public SelectionListType getTransportProfileUriNode();

    public String getTransportProfileUri();

    public void setTransportProfileUri(String var1);

    public NetworkAddressType getAddressNode();

    public ConnectionTransportType getTransportSettingsNode();

    public PubSubStatusType getStatusNode();

    public PubSubDiagnosticsConnectionType getDiagnosticsNode();

    public MethodNode getAddWriterGroupMethodNode();

    public MethodNode getAddReaderGroupMethodNode();

    public MethodNode getRemoveGroupMethodNode();

    public static abstract class RemoveGroupMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveGroupMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("GroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId groupId = (NodeId)inputValues[0].getValue();
            this.invoke(context, groupId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2) throws UaException;
    }

    public static abstract class AddReaderGroupMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddReaderGroupMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Configuration", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15520").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("GroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ReaderGroupDataType configuration = (ReaderGroupDataType)inputValues[0].getValue();
            Out<NodeId> groupId = new Out<NodeId>();
            this.invoke(context, configuration, groupId);
            return new Variant[]{new Variant((Object)groupId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ReaderGroupDataType var2, Out<NodeId> var3) throws UaException;
    }

    public static abstract class AddWriterGroupMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddWriterGroupMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Configuration", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15480").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("GroupId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            WriterGroupDataType configuration = (WriterGroupDataType)inputValues[0].getValue();
            Out<NodeId> groupId = new Out<NodeId>();
            this.invoke(context, configuration, groupId);
            return new Variant[]{new Variant((Object)groupId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, WriterGroupDataType var2, Out<NodeId> var3) throws UaException;
    }
}

