/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.model.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.model.variables.TwoStateVariableType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface DialogConditionType
extends ConditionType {
    public static final QualifiedProperty<LocalizedText> PROMPT = new QualifiedProperty("http://opcfoundation.org/UA/", "Prompt", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21"), Integer.valueOf(-1), LocalizedText.class);
    public static final QualifiedProperty<LocalizedText[]> RESPONSE_OPTION_SET = new QualifiedProperty("http://opcfoundation.org/UA/", "ResponseOptionSet", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21"), Integer.valueOf(1), LocalizedText[].class);
    public static final QualifiedProperty<Integer> DEFAULT_RESPONSE = new QualifiedProperty("http://opcfoundation.org/UA/", "DefaultResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6"), Integer.valueOf(-1), Integer.class);
    public static final QualifiedProperty<Integer> OK_RESPONSE = new QualifiedProperty("http://opcfoundation.org/UA/", "OkResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6"), Integer.valueOf(-1), Integer.class);
    public static final QualifiedProperty<Integer> CANCEL_RESPONSE = new QualifiedProperty("http://opcfoundation.org/UA/", "CancelResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6"), Integer.valueOf(-1), Integer.class);
    public static final QualifiedProperty<Integer> LAST_RESPONSE = new QualifiedProperty("http://opcfoundation.org/UA/", "LastResponse", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6"), Integer.valueOf(-1), Integer.class);

    public LocalizedText getPrompt();

    public void setPrompt(LocalizedText var1);

    public PropertyType getPromptNode();

    public LocalizedText[] getResponseOptionSet();

    public void setResponseOptionSet(LocalizedText[] var1);

    public PropertyType getResponseOptionSetNode();

    public Integer getDefaultResponse();

    public void setDefaultResponse(Integer var1);

    public PropertyType getDefaultResponseNode();

    public Integer getOkResponse();

    public void setOkResponse(Integer var1);

    public PropertyType getOkResponseNode();

    public Integer getCancelResponse();

    public void setCancelResponse(Integer var1);

    public PropertyType getCancelResponseNode();

    public Integer getLastResponse();

    public void setLastResponse(Integer var1);

    public PropertyType getLastResponseNode();

    @Override
    public TwoStateVariableType getEnabledStateNode();

    @Override
    public LocalizedText getEnabledState();

    @Override
    public void setEnabledState(LocalizedText var1);

    public TwoStateVariableType getDialogStateNode();

    public LocalizedText getDialogState();

    public void setDialogState(LocalizedText var1);

    public MethodNode getRespondMethodNode();

    public MethodNode getRespond2MethodNode();

    public static abstract class Respond2Method
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public Respond2Method(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SelectedResponse", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("Comment", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            Integer selectedResponse = (Integer)inputValues[0].getValue();
            LocalizedText comment = (LocalizedText)inputValues[1].getValue();
            this.invoke(context, selectedResponse, comment);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, Integer var2, LocalizedText var3) throws UaException;
    }

    public static abstract class RespondMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RespondMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SelectedResponse", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=6").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            Integer selectedResponse = (Integer)inputValues[0].getValue();
            this.invoke(context, selectedResponse);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, Integer var2) throws UaException;
    }
}

