/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.methods.Out;
import org.eclipse.milo.opcua.sdk.server.model.objects.FolderType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.types.structured.ConfigurationVersionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetFieldFlags;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetMetaDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishedVariableDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface DataSetFolderType
extends FolderType {
    public MethodNode getAddPublishedDataItemsMethodNode();

    public MethodNode getAddPublishedEventsMethodNode();

    public MethodNode getAddPublishedDataItemsTemplateMethodNode();

    public MethodNode getAddPublishedEventsTemplateMethodNode();

    public MethodNode getRemovePublishedDataSetMethodNode();

    public MethodNode getAddDataSetFolderMethodNode();

    public MethodNode getRemoveDataSetFolderMethodNode();

    public static abstract class RemoveDataSetFolderMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemoveDataSetFolderMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetFolderNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId dataSetFolderNodeId = (NodeId)inputValues[0].getValue();
            this.invoke(context, dataSetFolderNodeId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2) throws UaException;
    }

    public static abstract class AddDataSetFolderMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddDataSetFolderMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Name", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetFolderNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String name = (String)inputValues[0].getValue();
            Out<NodeId> dataSetFolderNodeId = new Out<NodeId>();
            this.invoke(context, name, dataSetFolderNodeId);
            return new Variant[]{new Variant((Object)dataSetFolderNodeId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, Out<NodeId> var3) throws UaException;
    }

    public static abstract class RemovePublishedDataSetMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public RemovePublishedDataSetMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            NodeId dataSetNodeId = (NodeId)inputValues[0].getValue();
            this.invoke(context, dataSetNodeId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, NodeId var2) throws UaException;
    }

    public static abstract class AddPublishedEventsTemplateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddPublishedEventsTemplateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Name", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("DataSetMetaData", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14523").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("EventNotifier", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("SelectedFields", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=601").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("Filter", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=586").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String name = (String)inputValues[0].getValue();
            DataSetMetaDataType dataSetMetaData = (DataSetMetaDataType)inputValues[1].getValue();
            NodeId eventNotifier = (NodeId)inputValues[2].getValue();
            SimpleAttributeOperand[] selectedFields = (SimpleAttributeOperand[])inputValues[3].getValue();
            ContentFilter filter = (ContentFilter)inputValues[4].getValue();
            Out<NodeId> dataSetNodeId = new Out<NodeId>();
            this.invoke(context, name, dataSetMetaData, eventNotifier, selectedFields, filter, dataSetNodeId);
            return new Variant[]{new Variant((Object)dataSetNodeId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, DataSetMetaDataType var3, NodeId var4, SimpleAttributeOperand[] var5, ContentFilter var6, Out<NodeId> var7) throws UaException;
    }

    public static abstract class AddPublishedDataItemsTemplateMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddPublishedDataItemsTemplateMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Name", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("DataSetMetaData", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14523").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("VariablesToAdd", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14273").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("AddResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String name = (String)inputValues[0].getValue();
            DataSetMetaDataType dataSetMetaData = (DataSetMetaDataType)inputValues[1].getValue();
            PublishedVariableDataType[] variablesToAdd = (PublishedVariableDataType[])inputValues[2].getValue();
            Out<NodeId> dataSetNodeId = new Out<NodeId>();
            Out<StatusCode[]> addResults = new Out<StatusCode[]>();
            this.invoke(context, name, dataSetMetaData, variablesToAdd, dataSetNodeId, addResults);
            return new Variant[]{new Variant((Object)dataSetNodeId.get()), new Variant((Object)addResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, DataSetMetaDataType var3, PublishedVariableDataType[] var4, Out<NodeId> var5, Out<StatusCode[]> var6) throws UaException;
    }

    public static abstract class AddPublishedEventsMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddPublishedEventsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Name", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("EventNotifier", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FieldNameAliases", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("FieldFlags", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15904").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("SelectedFields", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=601").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("Filter", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=586").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("DataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String name = (String)inputValues[0].getValue();
            NodeId eventNotifier = (NodeId)inputValues[1].getValue();
            String[] fieldNameAliases = (String[])inputValues[2].getValue();
            DataSetFieldFlags[] fieldFlags = (DataSetFieldFlags[])inputValues[3].getValue();
            SimpleAttributeOperand[] selectedFields = (SimpleAttributeOperand[])inputValues[4].getValue();
            ContentFilter filter = (ContentFilter)inputValues[5].getValue();
            Out<ConfigurationVersionDataType> configurationVersion = new Out<ConfigurationVersionDataType>();
            Out<NodeId> dataSetNodeId = new Out<NodeId>();
            this.invoke(context, name, eventNotifier, fieldNameAliases, fieldFlags, selectedFields, filter, configurationVersion, dataSetNodeId);
            return new Variant[]{new Variant((Object)configurationVersion.get()), new Variant((Object)dataSetNodeId.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, NodeId var3, String[] var4, DataSetFieldFlags[] var5, SimpleAttributeOperand[] var6, ContentFilter var7, Out<ConfigurationVersionDataType> var8, Out<NodeId> var9) throws UaException;
    }

    public static abstract class AddPublishedDataItemsMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();
        private final Lazy<Argument[]> outputArguments = new Lazy();

        public AddPublishedDataItemsMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("Name", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("FieldNameAliases", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("FieldFlags", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15904").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", "")), new Argument("VariablesToAdd", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14273").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return (Argument[])this.outputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("DataSetNodeId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("ConfigurationVersion", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=14593").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "")), new Argument("AddResults", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=19").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(1), new UInteger[]{UInteger.valueOf((int)0)}, new LocalizedText("", ""))};
            });
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            String name = (String)inputValues[0].getValue();
            String[] fieldNameAliases = (String[])inputValues[1].getValue();
            DataSetFieldFlags[] fieldFlags = (DataSetFieldFlags[])inputValues[2].getValue();
            PublishedVariableDataType[] variablesToAdd = (PublishedVariableDataType[])inputValues[3].getValue();
            Out<NodeId> dataSetNodeId = new Out<NodeId>();
            Out<ConfigurationVersionDataType> configurationVersion = new Out<ConfigurationVersionDataType>();
            Out<StatusCode[]> addResults = new Out<StatusCode[]>();
            this.invoke(context, name, fieldNameAliases, fieldFlags, variablesToAdd, dataSetNodeId, configurationVersion, addResults);
            return new Variant[]{new Variant((Object)dataSetNodeId.get()), new Variant((Object)configurationVersion.get()), new Variant((Object)addResults.get())};
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, String var2, String[] var3, DataSetFieldFlags[] var4, PublishedVariableDataType[] var5, Out<NodeId> var6, Out<ConfigurationVersionDataType> var7, Out<StatusCode[]> var8) throws UaException;
    }
}

