/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.model.objects.BaseEventType;
import org.eclipse.milo.opcua.sdk.server.model.variables.ConditionVariableType;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.sdk.server.model.variables.TwoStateVariableType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.eclipse.milo.opcua.stack.core.util.Lazy;

public interface ConditionType
extends BaseEventType {
    public static final QualifiedProperty<NodeId> CONDITION_CLASS_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "ConditionClassId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17"), Integer.valueOf(-1), NodeId.class);
    public static final QualifiedProperty<LocalizedText> CONDITION_CLASS_NAME = new QualifiedProperty("http://opcfoundation.org/UA/", "ConditionClassName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21"), Integer.valueOf(-1), LocalizedText.class);
    public static final QualifiedProperty<NodeId[]> CONDITION_SUB_CLASS_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "ConditionSubClassId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17"), Integer.valueOf(1), NodeId[].class);
    public static final QualifiedProperty<LocalizedText[]> CONDITION_SUB_CLASS_NAME = new QualifiedProperty("http://opcfoundation.org/UA/", "ConditionSubClassName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21"), Integer.valueOf(1), LocalizedText[].class);
    public static final QualifiedProperty<String> CONDITION_NAME = new QualifiedProperty("http://opcfoundation.org/UA/", "ConditionName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<NodeId> BRANCH_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "BranchId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=17"), Integer.valueOf(-1), NodeId.class);
    public static final QualifiedProperty<Boolean> RETAIN = new QualifiedProperty("http://opcfoundation.org/UA/", "Retain", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<Boolean> SUPPORTS_FILTERED_RETAIN = new QualifiedProperty("http://opcfoundation.org/UA/", "SupportsFilteredRetain", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=1"), Integer.valueOf(-1), Boolean.class);
    public static final QualifiedProperty<String> CLIENT_USER_ID = new QualifiedProperty("http://opcfoundation.org/UA/", "ClientUserId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=12"), Integer.valueOf(-1), String.class);

    @Override
    public NodeId getConditionClassId();

    @Override
    public void setConditionClassId(NodeId var1);

    @Override
    public PropertyType getConditionClassIdNode();

    @Override
    public LocalizedText getConditionClassName();

    @Override
    public void setConditionClassName(LocalizedText var1);

    @Override
    public PropertyType getConditionClassNameNode();

    @Override
    public NodeId[] getConditionSubClassId();

    @Override
    public void setConditionSubClassId(NodeId[] var1);

    @Override
    public PropertyType getConditionSubClassIdNode();

    @Override
    public LocalizedText[] getConditionSubClassName();

    @Override
    public void setConditionSubClassName(LocalizedText[] var1);

    @Override
    public PropertyType getConditionSubClassNameNode();

    public String getConditionName();

    public void setConditionName(String var1);

    public PropertyType getConditionNameNode();

    public NodeId getBranchId();

    public void setBranchId(NodeId var1);

    public PropertyType getBranchIdNode();

    public Boolean getRetain();

    public void setRetain(Boolean var1);

    public PropertyType getRetainNode();

    public Boolean getSupportsFilteredRetain();

    public void setSupportsFilteredRetain(Boolean var1);

    public PropertyType getSupportsFilteredRetainNode();

    public String getClientUserId();

    public void setClientUserId(String var1);

    public PropertyType getClientUserIdNode();

    public TwoStateVariableType getEnabledStateNode();

    public LocalizedText getEnabledState();

    public void setEnabledState(LocalizedText var1);

    public ConditionVariableType getQualityNode();

    public StatusCode getQuality();

    public void setQuality(StatusCode var1);

    public ConditionVariableType getLastSeverityNode();

    public UShort getLastSeverity();

    public void setLastSeverity(UShort var1);

    public ConditionVariableType getCommentNode();

    public LocalizedText getComment();

    public void setComment(LocalizedText var1);

    public MethodNode getDisableMethodNode();

    public MethodNode getEnableMethodNode();

    public MethodNode getAddCommentMethodNode();

    public MethodNode getConditionRefreshMethodNode();

    public MethodNode getConditionRefresh2MethodNode();

    public static abstract class ConditionRefresh2Method
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public ConditionRefresh2Method(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscriptionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=288").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The identifier for the subscription to refresh.")), new Argument("MonitoredItemId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=288").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The identifier for the monitored item to refresh."))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger subscriptionId = (UInteger)inputValues[0].getValue();
            UInteger monitoredItemId = (UInteger)inputValues[1].getValue();
            this.invoke(context, subscriptionId, monitoredItemId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2, UInteger var3) throws UaException;
    }

    public static abstract class ConditionRefreshMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public ConditionRefreshMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("SubscriptionId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=288").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The identifier for the subscription to refresh."))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            UInteger subscriptionId = (UInteger)inputValues[0].getValue();
            this.invoke(context, subscriptionId);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, UInteger var2) throws UaException;
    }

    public static abstract class AddCommentMethod
    extends AbstractMethodInvocationHandler {
        private final Lazy<Argument[]> inputArguments = new Lazy();

        public AddCommentMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return (Argument[])this.inputArguments.get(() -> {
                NamespaceTable namespaceTable = this.getNode().getNodeContext().getNamespaceTable();
                return new Argument[]{new Argument("EventId", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=15").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The identifier for the event to comment.")), new Argument("Comment", (NodeId)ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=21").toNodeId(namespaceTable).orElseThrow(), Integer.valueOf(-1), null, new LocalizedText("", "The comment to add to the condition."))};
            });
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            ByteString eventId = (ByteString)inputValues[0].getValue();
            LocalizedText comment = (LocalizedText)inputValues[1].getValue();
            this.invoke(context, eventId, comment);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1, ByteString var2, LocalizedText var3) throws UaException;
    }

    public static abstract class EnableMethod
    extends AbstractMethodInvocationHandler {
        public EnableMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }

    public static abstract class DisableMethod
    extends AbstractMethodInvocationHandler {
        public DisableMethod(UaMethodNode node) {
            super(node);
        }

        @Override
        public Argument[] getInputArguments() {
            return new Argument[0];
        }

        @Override
        public Argument[] getOutputArguments() {
            return new Argument[0];
        }

        @Override
        protected Variant[] invoke(AbstractMethodInvocationHandler.InvocationContext context, Variant[] inputValues) throws UaException {
            this.invoke(context);
            return new Variant[0];
        }

        protected abstract void invoke(AbstractMethodInvocationHandler.InvocationContext var1) throws UaException;
    }
}

