/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractUsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.DefaultUsernameIdentity;
import org.jspecify.annotations.Nullable;

public class UsernameIdentityValidator
extends AbstractUsernameIdentityValidator {
    private final Predicate<AuthenticationChallenge> predicate;

    public UsernameIdentityValidator(Predicate<AuthenticationChallenge> predicate) {
        this.predicate = predicate;
    }

    @Override
    protected  @Nullable Identity.UsernameIdentity authenticateUsernamePassword(Session session, String username, String password) {
        AuthenticationChallenge challenge = new AuthenticationChallenge(username, password);
        return this.predicate.test(challenge) ? new DefaultUsernameIdentity(username) : null;
    }

    public static final class AuthenticationChallenge {
        private final String username;
        private final String password;

        AuthenticationChallenge(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

