/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.security.cert.X509Certificate;
import java.util.Set;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.Identity;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.eclipse.milo.shaded.com.google.common.primitives.Bytes;
import org.jspecify.annotations.Nullable;

public abstract class AbstractX509IdentityValidator
extends AbstractIdentityValidator {
    @Override
    public Set<UserTokenType> getSupportedTokenTypes() {
        return Set.of(UserTokenType.Certificate);
    }

    @Override
    protected Identity.X509UserIdentity validateX509Token(Session session, X509IdentityToken token, UserTokenPolicy policy, SignatureData signature) throws UaException {
        SecurityAlgorithm algorithm;
        ByteString clientCertificateBs = token.getCertificateData();
        X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])clientCertificateBs.bytesOrEmpty());
        if (policy.getSecurityPolicyUri() != null) {
            securityPolicy = SecurityPolicy.fromUri((String)policy.getSecurityPolicyUri());
            if (!securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(signature.getAlgorithm())) {
                throw new UaException(0x80200000L, "algorithm in token signature did not match algorithm specified by token policy");
            }
        } else {
            securityPolicy = session.getSecurityConfiguration().getSecurityPolicy();
            if (!securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(signature.getAlgorithm())) {
                throw new UaException(0x80200000L, "algorithm in token signature did not match algorithm specified by secure channel");
            }
        }
        if ((algorithm = SecurityAlgorithm.fromUri((String)signature.getAlgorithm())) != SecurityAlgorithm.None) {
            try {
                AbstractX509IdentityValidator.verifySignature(session, signature, certificate, algorithm);
            }
            catch (UaException e) {
                throw new UaException(0x80200000L, "signature verification failed: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.authenticateCertificateOrThrow(session, certificate);
    }

    private Identity.X509UserIdentity authenticateCertificateOrThrow(Session session, X509Certificate certificate) throws UaException {
        Identity.X509UserIdentity identity = this.authenticateCertificate(session, certificate);
        if (identity != null) {
            return identity;
        }
        throw new UaException(2149646336L);
    }

    protected abstract  @Nullable Identity.X509UserIdentity authenticateCertificate(Session var1, X509Certificate var2);

    private static void verifySignature(Session session, SignatureData tokenSignature, X509Certificate certificate, SecurityAlgorithm algorithm) throws UaException {
        ByteString serverCertificateBs = session.getEndpoint().getServerCertificate();
        ByteString lastNonceBs = session.getLastNonce();
        try {
            byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
            byte[] signatureBytes = tokenSignature.getSignature().bytesOrEmpty();
            SignatureUtil.verify((SecurityAlgorithm)algorithm, (X509Certificate)certificate, (byte[])dataBytes, (byte[])signatureBytes);
        }
        catch (UaException e) {
            ByteString serverCertificateChainBs = session.getSecurityConfiguration().getServerCertificateChainBytes();
            if (serverCertificateBs.equals((Object)serverCertificateChainBs)) {
                throw e;
            }
            byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateChainBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
            byte[] signatureBytes = tokenSignature.getSignature().bytesOrEmpty();
            SignatureUtil.verify((SecurityAlgorithm)algorithm, (X509Certificate)certificate, (byte[])dataBytes, (byte[])signatureBytes);
        }
    }
}

