/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class ExpandedNodeIdConversions {
    private ExpandedNodeIdConversions() {
    }

    static @Nullable NodeId expandedNodeIdToNodeId(@NonNull ExpandedNodeId e) {
        return e.toNodeId(new NamespaceTable()).orElse(null);
    }

    static @NonNull String expandedNodeIdToString(@NonNull ExpandedNodeId e) {
        return e.toParseableString();
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof ExpandedNodeId) {
            ExpandedNodeId eni = (ExpandedNodeId)o;
            return implicit ? ExpandedNodeIdConversions.implicitConversion(eni, targetType) : ExpandedNodeIdConversions.explicitConversion(eni, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull ExpandedNodeId eni, OpcUaDataType targetType) {
        switch (targetType) {
            case NodeId: {
                return ExpandedNodeIdConversions.expandedNodeIdToNodeId(eni);
            }
        }
        return ExpandedNodeIdConversions.implicitConversion(eni, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull ExpandedNodeId eni, OpcUaDataType targetType) {
        switch (targetType) {
            case String: {
                return ExpandedNodeIdConversions.expandedNodeIdToString(eni);
            }
        }
        return null;
    }
}

