/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.milo.opcua.stack.core.OpcUaDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class DateTimeConversions {
    private static final DateFormat ISO_8601_UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private DateTimeConversions() {
    }

    static @NonNull String dateTimeToString(@NonNull DateTime dt) {
        return DateTimeConversions.dateToIso8601UtcString(dt.getJavaDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dateToIso8601UtcString(Date date) {
        DateFormat dateFormat = ISO_8601_UTC_DATE_FORMAT;
        synchronized (dateFormat) {
            return ISO_8601_UTC_DATE_FORMAT.format(date);
        }
    }

    static @Nullable Object convert(@NonNull Object o, OpcUaDataType targetType, boolean implicit) {
        if (o instanceof DateTime) {
            DateTime d = (DateTime)o;
            return implicit ? DateTimeConversions.implicitConversion(d, targetType) : DateTimeConversions.explicitConversion(d, targetType);
        }
        return null;
    }

    static @Nullable Object explicitConversion(@NonNull DateTime d, OpcUaDataType targetType) {
        switch (targetType) {
            case String: {
                return DateTimeConversions.dateTimeToString(d);
            }
        }
        return DateTimeConversions.implicitConversion(d, targetType);
    }

    static @Nullable Object implicitConversion(@NonNull DateTime d, OpcUaDataType targetType) {
        return null;
    }

    static {
        ISO_8601_UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

