/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.ValueRank;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.NodeManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SubscriptionDiagnosticsVariable;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SubscriptionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SubscriptionDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionCreatedEvent;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionDeletedEvent;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;
import org.eclipse.milo.shaded.com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionDiagnosticsVariableArray
extends AbstractLifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private AttributeObserver attributeObserver;
    private EventSubscriber eventSubscriber;
    private final List<SubscriptionDiagnosticsVariable> subscriptionDiagnosticsVariables = Collections.synchronizedList(new ArrayList());
    private final OpcUaServer server;
    private final NodeFactory nodeFactory;
    private final NodeManager<UaNode> diagnosticsNodeManager;
    private final SubscriptionDiagnosticsArrayTypeNode node;

    public SubscriptionDiagnosticsVariableArray(SubscriptionDiagnosticsArrayTypeNode node, final NodeManager<UaNode> diagnosticsNodeManager) {
        this.node = node;
        this.diagnosticsNodeManager = diagnosticsNodeManager;
        this.server = node.getNodeContext().getServer();
        this.nodeFactory = new NodeFactory(new UaNodeContext(){

            @Override
            public OpcUaServer getServer() {
                return SubscriptionDiagnosticsVariableArray.this.server;
            }

            @Override
            public NodeManager<UaNode> getNodeManager() {
                return diagnosticsNodeManager;
            }
        });
    }

    protected abstract List<Subscription> getSubscriptions();

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        if (this.diagnosticsEnabled.get()) {
            this.eventSubscriber = new EventSubscriber();
            this.server.getInternalEventBus().register((Object)this.eventSubscriber);
        }
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).value().value()) instanceof Boolean) {
                boolean current = (Boolean)o;
                boolean previous = this.diagnosticsEnabled.getAndSet(current);
                if (!previous && current) {
                    this.getSubscriptions().forEach(this::createSubscriptionDiagnosticsNode);
                    if (this.eventSubscriber == null) {
                        this.eventSubscriber = new EventSubscriber();
                        this.server.getInternalEventBus().register((Object)this.eventSubscriber);
                    }
                } else if (previous && !current) {
                    if (this.eventSubscriber != null) {
                        this.server.getInternalEventBus().unregister((Object)this.eventSubscriber);
                        this.eventSubscriber = null;
                    }
                    this.subscriptionDiagnosticsVariables.forEach(AbstractLifecycle::shutdown);
                    this.subscriptionDiagnosticsVariables.clear();
                }
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject[] xos = ExtensionObject.encodeArray((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType[])((UaStructuredType[])this.getSubscriptions().stream().map(s -> s.getSubscriptionDiagnostics().getSubscriptionDiagnosticsDataType()).toArray(SubscriptionDiagnosticsDataType[]::new)));
            return new DataValue(new Variant((Object)xos));
        }));
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        if (this.eventSubscriber != null) {
            this.server.getInternalEventBus().unregister((Object)this.eventSubscriber);
            this.eventSubscriber = null;
        }
        this.subscriptionDiagnosticsVariables.forEach(AbstractLifecycle::shutdown);
        this.subscriptionDiagnosticsVariables.clear();
        this.node.delete();
    }

    private void createSubscriptionDiagnosticsNode(Subscription subscription) {
        try {
            int index = this.subscriptionDiagnosticsVariables.size();
            String id = Util.buildBrowseNamePath(this.node) + "[" + index + "]";
            NodeId elementNodeId = new NodeId(1, id);
            SubscriptionDiagnosticsTypeNode elementNode = (SubscriptionDiagnosticsTypeNode)this.nodeFactory.createNode(elementNodeId, NodeIds.SubscriptionDiagnosticsType);
            elementNode.setBrowseName(new QualifiedName(1, subscription.getId().toString()));
            elementNode.setDisplayName(new LocalizedText(this.node.getDisplayName().locale(), subscription.getId().toString()));
            elementNode.setArrayDimensions(null);
            elementNode.setValueRank(ValueRank.Scalar.getValue());
            elementNode.setDataType(NodeIds.SubscriptionDiagnosticsDataType);
            elementNode.setAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_ONLY));
            elementNode.setUserAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_ONLY));
            elementNode.addReference(new Reference(elementNode.getNodeId(), NodeIds.HasComponent, this.node.getNodeId().expanded(), Reference.Direction.INVERSE));
            this.diagnosticsNodeManager.addNode(elementNode);
            SubscriptionDiagnosticsVariable diagnosticsVariable = new SubscriptionDiagnosticsVariable(elementNode, subscription);
            diagnosticsVariable.startup();
            this.subscriptionDiagnosticsVariables.add(diagnosticsVariable);
        }
        catch (UaException e) {
            this.logger.error("Failed to create SubscriptionDiagnosticsTypeNode for subscription id={}", (Object)subscription.getId(), (Object)e);
        }
    }

    private class EventSubscriber {
        private EventSubscriber() {
        }

        @Subscribe
        public synchronized void onSubscriptionCreated(SubscriptionCreatedEvent event) {
            if (SubscriptionDiagnosticsVariableArray.this.getSubscriptions().stream().anyMatch(s -> s.getId().equals((Object)event.getSubscription().getId()))) {
                SubscriptionDiagnosticsVariableArray.this.createSubscriptionDiagnosticsNode(event.getSubscription());
            }
        }

        @Subscribe
        public synchronized void onSubscriptionDeleted(SubscriptionDeletedEvent event) {
            for (int i = 0; i < SubscriptionDiagnosticsVariableArray.this.subscriptionDiagnosticsVariables.size(); ++i) {
                Subscription subscription = SubscriptionDiagnosticsVariableArray.this.subscriptionDiagnosticsVariables.get(i).getSubscription();
                if (!event.getSubscription().getId().equals((Object)subscription.getId())) continue;
                SubscriptionDiagnosticsVariable diagnosticsVariable = SubscriptionDiagnosticsVariableArray.this.subscriptionDiagnosticsVariables.remove(i);
                diagnosticsVariable.shutdown();
                break;
            }
        }
    }
}

