/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.diagnostics.SubscriptionDiagnostics;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SubscriptionDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class SubscriptionDiagnosticsVariable
extends AbstractLifecycle {
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private AttributeObserver attributeObserver;
    private final OpcUaServer server;
    private final SubscriptionDiagnosticsTypeNode node;
    private final Subscription subscription;

    public SubscriptionDiagnosticsVariable(SubscriptionDiagnosticsTypeNode node, Subscription subscription) {
        this.node = node;
        this.subscription = subscription;
        this.server = node.getNodeContext().getServer();
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).value().value()) instanceof Boolean) {
                this.diagnosticsEnabled.set((Boolean)o);
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        SubscriptionDiagnostics subscriptionDiagnostics = this.subscription.getSubscriptionDiagnostics();
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject xo = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)subscriptionDiagnostics.getSubscriptionDiagnosticsDataType());
            return new DataValue(new Variant((Object)xo));
        }));
        this.node.getSessionIdNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            NodeId value = subscriptionDiagnostics.getSessionId();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSubscriptionIdNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = subscriptionDiagnostics.getSubscriptionId();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getPriorityNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UByte value = subscriptionDiagnostics.getPriority();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getPublishingIntervalNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            Double value = subscriptionDiagnostics.getPublishingInterval();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getMaxKeepAliveCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = subscriptionDiagnostics.getMaxKeepAliveCount();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getMaxLifetimeCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = subscriptionDiagnostics.getMaxLifetimeCount();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getMaxNotificationsPerPublishNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = subscriptionDiagnostics.getMaxNotificationsPerPublish();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getPublishingEnabledNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            Boolean value = subscriptionDiagnostics.isPublishingEnabled();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getModifyCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getModifyCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getEnableCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getEnableCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDisableCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getDisableCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getRepublishRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getRepublishRequestCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getRepublishMessageRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getRepublishMessageRequestCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getRepublishMessageCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getRepublishMessageCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTransferRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getTransferRequestCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTransferredToAltClientCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getTransferredToAltClientCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTransferredToSameClientCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getTransferredToSameClientCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getPublishRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getPublishRequestCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDataChangeNotificationsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getDataChangeNotificationsCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getEventNotificationsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getEventNotificationsCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getNotificationsCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getNotificationsCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getLatePublishRequestCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getLatePublishRequestCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCurrentKeepAliveCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getCurrentKeepAliveCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getCurrentLifetimeCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getCurrentLifetimeCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getUnacknowledgedMessageCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getUnacknowledgedMessageCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDiscardedMessageCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getDiscardedMessageCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getMonitoredItemCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getMonitoredItemCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getDisabledMonitoredItemCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getDisabledMonitoredItemCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getMonitoringQueueOverflowCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getMonitoringQueueOverflowCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getNextSequenceNumberNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getNextSequenceNumber().longValue());
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getEventQueueOverflowCountNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            UInteger value = Unsigned.uint((long)subscriptionDiagnostics.getEventQueueOverflowCount().longValue());
            return new DataValue(new Variant((Object)value));
        }));
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        this.node.delete();
    }
}

