/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SessionSecurityDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;

public class SessionSecurityDiagnosticsVariable
extends AbstractLifecycle {
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private AttributeObserver attributeObserver;
    private final OpcUaServer server;
    private final SessionSecurityDiagnosticsTypeNode node;
    private final Session session;

    public SessionSecurityDiagnosticsVariable(SessionSecurityDiagnosticsTypeNode node, Session session) {
        this.node = node;
        this.session = session;
        this.server = node.getNodeContext().getServer();
    }

    public SessionSecurityDiagnosticsTypeNode getNode() {
        return this.node;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).value().value()) instanceof Boolean) {
                this.diagnosticsEnabled.set((Boolean)o);
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject xo = ExtensionObject.encode((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType)this.session.getSessionSecurityDiagnostics().getSessionSecurityDiagnosticsDataType());
            return new DataValue(new Variant((Object)xo));
        }));
        this.node.getSessionIdNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            NodeId value = this.session.getSessionSecurityDiagnostics().getSessionId();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getClientUserIdOfSessionNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionSecurityDiagnostics().getClientUserIdOfSession();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getClientUserIdHistoryNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String[] value = this.session.getSessionSecurityDiagnostics().getClientUserIdHistory();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getAuthenticationMechanismNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionSecurityDiagnostics().getAuthenticationMechanism();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getEncodingNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionSecurityDiagnostics().getEncoding();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getTransportProtocolNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionSecurityDiagnostics().getTransportProtocol();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSecurityModeNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            MessageSecurityMode value = this.session.getSessionSecurityDiagnostics().getSecurityMode();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getSecurityPolicyUriNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            String value = this.session.getSessionSecurityDiagnostics().getSecurityPolicyUri();
            return new DataValue(new Variant((Object)value));
        }));
        this.node.getClientCertificateNode().getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ByteString value = this.session.getSessionSecurityDiagnostics().getClientCertificate();
            return new DataValue(new Variant((Object)value));
        }));
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        this.node.delete();
    }
}

