/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.ValueRank;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.NodeManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.SessionListener;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.SessionDiagnosticsVariable;
import org.eclipse.milo.opcua.sdk.server.diagnostics.variables.Util;
import org.eclipse.milo.opcua.sdk.server.model.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SessionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.SessionDiagnosticsVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.SessionDiagnosticsDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDiagnosticsVariableArray
extends AbstractLifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean diagnosticsEnabled = new AtomicBoolean(false);
    private final List<SessionDiagnosticsVariable> sessionDiagnosticsVariables = Collections.synchronizedList(new ArrayList());
    private AttributeObserver attributeObserver;
    private SessionListener sessionListener;
    private final OpcUaServer server;
    private final NodeFactory nodeFactory;
    private final SessionDiagnosticsArrayTypeNode node;
    private final NodeManager<UaNode> diagnosticsNodeManager;

    public SessionDiagnosticsVariableArray(SessionDiagnosticsArrayTypeNode node, final NodeManager<UaNode> diagnosticsNodeManager) {
        this.node = node;
        this.diagnosticsNodeManager = diagnosticsNodeManager;
        this.server = node.getNodeContext().getServer();
        this.nodeFactory = new NodeFactory(new UaNodeContext(){

            @Override
            public OpcUaServer getServer() {
                return SessionDiagnosticsVariableArray.this.server;
            }

            @Override
            public NodeManager<UaNode> getNodeManager() {
                return diagnosticsNodeManager;
            }
        });
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
        this.diagnosticsEnabled.set(diagnosticsNode.getEnabledFlag());
        if (this.diagnosticsEnabled.get()) {
            this.addSessionListener();
        }
        this.attributeObserver = (node, attributeId, value) -> {
            DataValue dataValue;
            Object o;
            if (attributeId == AttributeId.Value && (o = (dataValue = (DataValue)value).value().value()) instanceof Boolean) {
                boolean current = (Boolean)o;
                boolean previous = this.diagnosticsEnabled.getAndSet(current);
                if (!previous && current) {
                    this.server.getSessionManager().getAllSessions().forEach(this::createSessionDiagnosticsVariable);
                    if (this.sessionListener == null) {
                        this.addSessionListener();
                    }
                } else if (previous && !current) {
                    if (this.sessionListener != null) {
                        this.server.getSessionManager().removeSessionListener(this.sessionListener);
                        this.sessionListener = null;
                    }
                    this.sessionDiagnosticsVariables.forEach(Lifecycle::shutdown);
                    this.sessionDiagnosticsVariables.clear();
                }
            }
        };
        diagnosticsNode.getEnabledFlagNode().addAttributeObserver(this.attributeObserver);
        this.node.getFilterChain().addLast(Util.diagnosticValueFilter(this.diagnosticsEnabled, ctx -> {
            ExtensionObject[] xos = ExtensionObject.encodeArray((EncodingContext)this.server.getStaticEncodingContext(), (UaStructuredType[])((UaStructuredType[])this.server.getSessionManager().getAllSessions().stream().map(s -> s.getSessionDiagnostics().getSessionDiagnosticsDataType()).toArray(SessionDiagnosticsDataType[]::new)));
            return new DataValue(new Variant((Object)xos));
        }));
    }

    private void addSessionListener() {
        this.sessionListener = new SessionListener(){

            @Override
            public void onSessionCreated(Session session) {
                SessionDiagnosticsVariableArray.this.createSessionDiagnosticsVariable(session);
            }

            @Override
            public void onSessionClosed(Session session) {
                for (int i = 0; i < SessionDiagnosticsVariableArray.this.sessionDiagnosticsVariables.size(); ++i) {
                    SessionDiagnosticsVariable v = SessionDiagnosticsVariableArray.this.sessionDiagnosticsVariables.get(i);
                    if (!v.getSession().getSessionId().equals((Object)session.getSessionId())) continue;
                    SessionDiagnosticsVariableArray.this.sessionDiagnosticsVariables.remove(i);
                    v.shutdown();
                    break;
                }
            }
        };
        this.server.getSessionManager().addSessionListener(this.sessionListener);
    }

    private void createSessionDiagnosticsVariable(Session session) {
        try {
            int index = this.sessionDiagnosticsVariables.size();
            String id = Util.buildBrowseNamePath(this.node) + "[" + index + "]";
            NodeId elementNodeId = new NodeId(1, id);
            SessionDiagnosticsVariableTypeNode elementNode = (SessionDiagnosticsVariableTypeNode)this.nodeFactory.createNode(elementNodeId, NodeIds.SessionDiagnosticsVariableType);
            elementNode.setBrowseName(new QualifiedName(1, "SessionDiagnostics"));
            elementNode.setDisplayName(new LocalizedText(this.node.getDisplayName().locale(), "SessionDiagnostics"));
            elementNode.setArrayDimensions(null);
            elementNode.setValueRank(ValueRank.Scalar.getValue());
            elementNode.setDataType(NodeIds.SessionDiagnosticsDataType);
            elementNode.setAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_ONLY));
            elementNode.setUserAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_ONLY));
            elementNode.addReference(new Reference(elementNode.getNodeId(), NodeIds.HasComponent, this.node.getNodeId().expanded(), Reference.Direction.INVERSE));
            this.diagnosticsNodeManager.addNode(elementNode);
            SessionDiagnosticsVariable sessionDiagnosticsVariable = new SessionDiagnosticsVariable(elementNode, session);
            sessionDiagnosticsVariable.startup();
            this.sessionDiagnosticsVariables.add(sessionDiagnosticsVariable);
        }
        catch (UaException e) {
            this.logger.warn("Failed to create SessionDiagnosticsVariableTypeNode for session id={}", (Object)session.getSessionId(), (Object)e);
        }
    }

    @Override
    protected void onShutdown() {
        AttributeObserver observer = this.attributeObserver;
        if (observer != null) {
            ServerDiagnosticsTypeNode diagnosticsNode = (ServerDiagnosticsTypeNode)this.server.getAddressSpaceManager().getManagedNode(NodeIds.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + String.valueOf(NodeIds.Server_ServerDiagnostics)));
            diagnosticsNode.getEnabledFlagNode().removeAttributeObserver(observer);
            this.attributeObserver = null;
        }
        if (this.sessionListener != null) {
            this.server.getSessionManager().removeSessionListener(this.sessionListener);
            this.sessionListener = null;
        }
        this.sessionDiagnosticsVariables.forEach(Lifecycle::shutdown);
        this.sessionDiagnosticsVariables.clear();
        this.node.delete();
    }
}

