/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.milo.opcua.sdk.server.EndpointConfig;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.RoleMapper;
import org.eclipse.milo.opcua.sdk.server.identity.AnonymousIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;

public class OpcUaServerConfigBuilder {
    private Set<EndpointConfig> endpoints = new HashSet<EndpointConfig>();
    private LocalizedText applicationName = LocalizedText.english((String)"server application name not configured");
    private String applicationUri = "server application uri not configured";
    private String productUri = "server product uri not configured";
    private BuildInfo buildInfo = new BuildInfo("", "", "", "", "", DateTime.MIN_VALUE);
    private IdentityValidator identityValidator = AnonymousIdentityValidator.INSTANCE;
    private EncodingLimits encodingLimits = EncodingLimits.DEFAULT;
    private OpcUaServerConfigLimits limits = new OpcUaServerConfigLimits(){};
    private CertificateManager certificateManager;
    private RoleMapper roleMapper;
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    public OpcUaServerConfigBuilder setEndpoints(Set<EndpointConfig> endpointConfigs) {
        this.endpoints = endpointConfigs;
        return this;
    }

    public OpcUaServerConfigBuilder setApplicationName(LocalizedText applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public OpcUaServerConfigBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public OpcUaServerConfigBuilder setProductUri(String productUri) {
        this.productUri = productUri;
        return this;
    }

    public OpcUaServerConfigBuilder setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        return this;
    }

    public OpcUaServerConfigBuilder setEncodingLimits(EncodingLimits encodingLimits) {
        this.encodingLimits = encodingLimits;
        return this;
    }

    public OpcUaServerConfigBuilder setLimits(OpcUaServerConfigLimits limits) {
        this.limits = limits;
        return this;
    }

    public OpcUaServerConfigBuilder setIdentityValidator(IdentityValidator identityValidator) {
        this.identityValidator = identityValidator;
        return this;
    }

    public OpcUaServerConfigBuilder setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
        return this;
    }

    public OpcUaServerConfigBuilder setRoleMapper(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
        return this;
    }

    public OpcUaServerConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public OpcUaServerConfigBuilder setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        return this;
    }

    public OpcUaServerConfig build() {
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Stack.sharedScheduledExecutor();
        }
        return new OpcUaServerConfigImpl(this.endpoints, this.applicationName, this.applicationUri, this.productUri, this.buildInfo, this.identityValidator, this.encodingLimits, this.limits, this.certificateManager, this.roleMapper, this.executor, this.scheduledExecutor);
    }

    public static final class OpcUaServerConfigImpl
    implements OpcUaServerConfig {
        private final Set<EndpointConfig> endpoints;
        private final LocalizedText applicationName;
        private final String applicationUri;
        private final String productUri;
        private final BuildInfo buildInfo;
        private final IdentityValidator identityValidator;
        private final EncodingLimits encodingLimits;
        private final OpcUaServerConfigLimits limits;
        private final CertificateManager certificateManager;
        private final RoleMapper roleMapper;
        private final ExecutorService executor;
        private final ScheduledExecutorService scheduledExecutorService;

        public OpcUaServerConfigImpl(Set<EndpointConfig> endpoints, LocalizedText applicationName, String applicationUri, String productUri, BuildInfo buildInfo, IdentityValidator identityValidator, EncodingLimits encodingLimits, OpcUaServerConfigLimits limits, CertificateManager certificateManager, RoleMapper roleMapper, ExecutorService executor, ScheduledExecutorService scheduledExecutorService) {
            this.endpoints = endpoints;
            this.applicationName = applicationName;
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.buildInfo = buildInfo;
            this.identityValidator = identityValidator;
            this.encodingLimits = encodingLimits;
            this.limits = limits;
            this.certificateManager = certificateManager;
            this.roleMapper = roleMapper;
            this.executor = executor;
            this.scheduledExecutorService = scheduledExecutorService;
        }

        @Override
        public IdentityValidator getIdentityValidator() {
            return this.identityValidator;
        }

        @Override
        public BuildInfo getBuildInfo() {
            return this.buildInfo;
        }

        @Override
        public Set<EndpointConfig> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationUri() {
            return this.applicationUri;
        }

        @Override
        public String getProductUri() {
            return this.productUri;
        }

        @Override
        public EncodingLimits getEncodingLimits() {
            return this.encodingLimits;
        }

        @Override
        public OpcUaServerConfigLimits getLimits() {
            return this.limits;
        }

        @Override
        public CertificateManager getCertificateManager() {
            return this.certificateManager;
        }

        @Override
        public Optional<RoleMapper> getRoleMapper() {
            return Optional.ofNullable(this.roleMapper);
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduledExecutorService;
        }
    }
}

