/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ObjectTypeManager {
    private final ConcurrentMap<NodeId, ObjectTypeDefinition> typeDefinitions = new ConcurrentHashMap<NodeId, ObjectTypeDefinition>();

    public void registerObjectType(NodeId typeDefinition, Class<? extends UaObjectNode> nodeClass, ObjectNodeConstructor objectNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new ObjectTypeDefinition(nodeClass, objectNodeConstructor));
    }

    public void registerObjectType(NodeId typeDefinition, Class<? extends UaObjectNode> nodeClass, final LegacyObjectNodeConstructor objectNodeConstructor) {
        ObjectNodeConstructor adapted = new ObjectNodeConstructor(){

            @Override
            public UaObjectNode apply(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions) {
                return objectNodeConstructor.apply(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
            }
        };
        this.typeDefinitions.put(typeDefinition, new ObjectTypeDefinition(nodeClass, adapted));
    }

    public Optional<ObjectNodeConstructor> getNodeConstructor(NodeId typeDefinition) {
        ObjectTypeDefinition def = (ObjectTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeConstructor);
    }

    private static class ObjectTypeDefinition {
        final Class<? extends UaNode> nodeClass;
        final ObjectNodeConstructor nodeConstructor;

        private ObjectTypeDefinition(Class<? extends UaNode> nodeClass, ObjectNodeConstructor nodeConstructor) {
            this.nodeClass = nodeClass;
            this.nodeConstructor = nodeConstructor;
        }
    }

    @FunctionalInterface
    public static interface ObjectNodeConstructor {
        public UaObjectNode apply(UaNodeContext var1, NodeId var2, QualifiedName var3, LocalizedText var4, LocalizedText var5, UInteger var6, UInteger var7, RolePermissionType[] var8, RolePermissionType[] var9, AccessRestrictionType var10);
    }

    @FunctionalInterface
    public static interface LegacyObjectNodeConstructor {
        public UaObjectNode apply(UaNodeContext var1, NodeId var2, QualifiedName var3, LocalizedText var4, LocalizedText var5, UInteger var6, UInteger var7);
    }
}

