/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.shaded.com.google.common.collect.Lists;

public final class LifecycleManager
extends AbstractLifecycle {
    private final CopyOnWriteArrayList<Lifecycle> lifecycles = new CopyOnWriteArrayList();
    private final ShutdownOrder shutdownOrder;

    public LifecycleManager() {
        this(ShutdownOrder.LINEAR);
    }

    public LifecycleManager(ShutdownOrder shutdownOrder) {
        this.shutdownOrder = shutdownOrder;
    }

    @Override
    protected void onStartup() {
        this.lifecycles.forEach(Lifecycle::startup);
    }

    @Override
    protected void onShutdown() {
        if (this.shutdownOrder == ShutdownOrder.LINEAR) {
            this.lifecycles.forEach(Lifecycle::shutdown);
        } else {
            Lists.reverse(this.lifecycles).forEach(Lifecycle::shutdown);
        }
    }

    public void addLifecycle(Lifecycle lifecycle) {
        this.lifecycles.add(lifecycle);
    }

    public void removeLifecycle(Lifecycle lifecycle) {
        this.lifecycles.remove(lifecycle);
    }

    public Lifecycle addStartupTask(final Runnable startupTask) {
        Lifecycle lifecycle = new Lifecycle(){

            @Override
            public void startup() {
                startupTask.run();
            }

            @Override
            public void shutdown() {
            }
        };
        this.addLifecycle(lifecycle);
        return lifecycle;
    }

    public Lifecycle addShutdownTask(final Runnable shutdownTask) {
        Lifecycle lifecycle = new Lifecycle(){

            @Override
            public void startup() {
            }

            @Override
            public void shutdown() {
                shutdownTask.run();
            }
        };
        this.addLifecycle(lifecycle);
        return lifecycle;
    }

    public static enum ShutdownOrder {
        LINEAR,
        INVERSE;

    }
}

