/*
 * Copyright (c) 2024 the Eclipse Milo Authors
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.milo.opcua.sdk.server.servicesets;

import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.transport.server.ServiceRequestContext;

public interface AttributeServiceSet {

  ReadResponse onRead(ServiceRequestContext context, ReadRequest request) throws UaException;

  HistoryReadResponse onHistoryRead(ServiceRequestContext context, HistoryReadRequest request)
      throws UaException;

  WriteResponse onWrite(ServiceRequestContext context, WriteRequest request) throws UaException;

  HistoryUpdateResponse onHistoryUpdate(ServiceRequestContext context, HistoryUpdateRequest request)
      throws UaException;
}
