/*
 * Copyright (c) 2025 the Eclipse Milo Authors
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.milo.opcua.sdk.server.model.objects;

import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;

/**
 * @see <a
 *     href="https://reference.opcfoundation.org/v105/Core/docs/Part5/6.3.2">https://reference.opcfoundation.org/v105/Core/docs/Part5/6.3.2</a>
 */
public interface ServerCapabilitiesType extends BaseObjectType {
  QualifiedProperty<String[]> SERVER_PROFILE_ARRAY =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "ServerProfileArray",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12"),
          1,
          String[].class);

  QualifiedProperty<String[]> LOCALE_ID_ARRAY =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "LocaleIdArray",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=295"),
          1,
          String[].class);

  QualifiedProperty<Double> MIN_SUPPORTED_SAMPLE_RATE =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MinSupportedSampleRate",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=290"),
          -1,
          Double.class);

  QualifiedProperty<UShort> MAX_BROWSE_CONTINUATION_POINTS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxBrowseContinuationPoints",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=5"),
          -1,
          UShort.class);

  QualifiedProperty<UShort> MAX_QUERY_CONTINUATION_POINTS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxQueryContinuationPoints",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=5"),
          -1,
          UShort.class);

  QualifiedProperty<UShort> MAX_HISTORY_CONTINUATION_POINTS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxHistoryContinuationPoints",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=5"),
          -1,
          UShort.class);

  QualifiedProperty<SignedSoftwareCertificate[]> SOFTWARE_CERTIFICATES =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "SoftwareCertificates",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=344"),
          1,
          SignedSoftwareCertificate[].class);

  QualifiedProperty<UInteger> MAX_ARRAY_LENGTH =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxArrayLength",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_STRING_LENGTH =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxStringLength",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_BYTE_STRING_LENGTH =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxByteStringLength",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_SESSIONS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxSessions",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_SUBSCRIPTIONS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxSubscriptions",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_MONITORED_ITEMS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxMonitoredItems",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_SUBSCRIPTIONS_PER_SESSION =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxSubscriptionsPerSession",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_MONITORED_ITEMS_PER_SUBSCRIPTION =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxMonitoredItemsPerSubscription",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_SELECT_CLAUSE_PARAMETERS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxSelectClauseParameters",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_WHERE_CLAUSE_PARAMETERS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxWhereClauseParameters",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<UInteger> MAX_MONITORED_ITEMS_QUEUE_SIZE =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "MaxMonitoredItemsQueueSize",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=7"),
          -1,
          UInteger.class);

  QualifiedProperty<QualifiedName[]> CONFORMANCE_UNITS =
      new QualifiedProperty<>(
          "http://opcfoundation.org/UA/",
          "ConformanceUnits",
          ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=20"),
          1,
          QualifiedName[].class);

  String[] getServerProfileArray();

  void setServerProfileArray(String[] value);

  PropertyType getServerProfileArrayNode();

  String[] getLocaleIdArray();

  void setLocaleIdArray(String[] value);

  PropertyType getLocaleIdArrayNode();

  Double getMinSupportedSampleRate();

  void setMinSupportedSampleRate(Double value);

  PropertyType getMinSupportedSampleRateNode();

  UShort getMaxBrowseContinuationPoints();

  void setMaxBrowseContinuationPoints(UShort value);

  PropertyType getMaxBrowseContinuationPointsNode();

  UShort getMaxQueryContinuationPoints();

  void setMaxQueryContinuationPoints(UShort value);

  PropertyType getMaxQueryContinuationPointsNode();

  UShort getMaxHistoryContinuationPoints();

  void setMaxHistoryContinuationPoints(UShort value);

  PropertyType getMaxHistoryContinuationPointsNode();

  SignedSoftwareCertificate[] getSoftwareCertificates();

  void setSoftwareCertificates(SignedSoftwareCertificate[] value);

  PropertyType getSoftwareCertificatesNode();

  UInteger getMaxArrayLength();

  void setMaxArrayLength(UInteger value);

  PropertyType getMaxArrayLengthNode();

  UInteger getMaxStringLength();

  void setMaxStringLength(UInteger value);

  PropertyType getMaxStringLengthNode();

  UInteger getMaxByteStringLength();

  void setMaxByteStringLength(UInteger value);

  PropertyType getMaxByteStringLengthNode();

  UInteger getMaxSessions();

  void setMaxSessions(UInteger value);

  PropertyType getMaxSessionsNode();

  UInteger getMaxSubscriptions();

  void setMaxSubscriptions(UInteger value);

  PropertyType getMaxSubscriptionsNode();

  UInteger getMaxMonitoredItems();

  void setMaxMonitoredItems(UInteger value);

  PropertyType getMaxMonitoredItemsNode();

  UInteger getMaxSubscriptionsPerSession();

  void setMaxSubscriptionsPerSession(UInteger value);

  PropertyType getMaxSubscriptionsPerSessionNode();

  UInteger getMaxMonitoredItemsPerSubscription();

  void setMaxMonitoredItemsPerSubscription(UInteger value);

  PropertyType getMaxMonitoredItemsPerSubscriptionNode();

  UInteger getMaxSelectClauseParameters();

  void setMaxSelectClauseParameters(UInteger value);

  PropertyType getMaxSelectClauseParametersNode();

  UInteger getMaxWhereClauseParameters();

  void setMaxWhereClauseParameters(UInteger value);

  PropertyType getMaxWhereClauseParametersNode();

  UInteger getMaxMonitoredItemsQueueSize();

  void setMaxMonitoredItemsQueueSize(UInteger value);

  PropertyType getMaxMonitoredItemsQueueSizeNode();

  QualifiedName[] getConformanceUnits();

  void setConformanceUnits(QualifiedName[] value);

  PropertyType getConformanceUnitsNode();

  OperationLimitsType getOperationLimitsNode();

  FolderType getModellingRulesNode();

  FolderType getAggregateFunctionsNode();

  RoleSetType getRoleSetNode();
}
