/*
 * Copyright (c) 2025 the Eclipse Milo Authors
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.milo.opcua.sdk.server.model.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.RedundantServerMode;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RedundantServerDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class NonTransparentBackupRedundancyTypeNode extends NonTransparentRedundancyTypeNode
    implements NonTransparentBackupRedundancyType {
  public NonTransparentBackupRedundancyTypeNode(
      UaNodeContext context,
      NodeId nodeId,
      QualifiedName browseName,
      LocalizedText displayName,
      LocalizedText description,
      UInteger writeMask,
      UInteger userWriteMask,
      RolePermissionType[] rolePermissions,
      RolePermissionType[] userRolePermissions,
      AccessRestrictionType accessRestrictions,
      UByte eventNotifier) {
    super(
        context,
        nodeId,
        browseName,
        displayName,
        description,
        writeMask,
        userWriteMask,
        rolePermissions,
        userRolePermissions,
        accessRestrictions,
        eventNotifier);
  }

  public NonTransparentBackupRedundancyTypeNode(
      UaNodeContext context,
      NodeId nodeId,
      QualifiedName browseName,
      LocalizedText displayName,
      LocalizedText description,
      UInteger writeMask,
      UInteger userWriteMask,
      RolePermissionType[] rolePermissions,
      RolePermissionType[] userRolePermissions,
      AccessRestrictionType accessRestrictions) {
    super(
        context,
        nodeId,
        browseName,
        displayName,
        description,
        writeMask,
        userWriteMask,
        rolePermissions,
        userRolePermissions,
        accessRestrictions);
  }

  @Override
  public PropertyTypeNode getRedundantServerArrayNode() {
    Optional<VariableNode> propertyNode =
        getPropertyNode(NonTransparentBackupRedundancyType.REDUNDANT_SERVER_ARRAY);
    return (PropertyTypeNode) propertyNode.orElse(null);
  }

  @Override
  public RedundantServerDataType[] getRedundantServerArray() {
    return getProperty(NonTransparentBackupRedundancyType.REDUNDANT_SERVER_ARRAY).orElse(null);
  }

  @Override
  public void setRedundantServerArray(RedundantServerDataType[] value) {
    setProperty(NonTransparentBackupRedundancyType.REDUNDANT_SERVER_ARRAY, value);
  }

  @Override
  public PropertyTypeNode getModeNode() {
    Optional<VariableNode> propertyNode = getPropertyNode(NonTransparentBackupRedundancyType.MODE);
    return (PropertyTypeNode) propertyNode.orElse(null);
  }

  @Override
  public RedundantServerMode getMode() {
    return getProperty(NonTransparentBackupRedundancyType.MODE).orElse(null);
  }

  @Override
  public void setMode(RedundantServerMode value) {
    setProperty(NonTransparentBackupRedundancyType.MODE, value);
  }

  @Override
  public UaMethodNode getFailoverMethodNode() {
    Optional<UaNode> methodNode =
        findNode(
            "http://opcfoundation.org/UA/",
            "Failover",
            node -> node instanceof UaMethodNode,
            Reference.HAS_COMPONENT_PREDICATE);
    return (UaMethodNode) methodNode.orElse(null);
  }
}
