/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.dtd;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.binaryschema.parser.BsdParser;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.dtd.DataTypeDictionaryReader;
import org.eclipse.milo.opcua.sdk.client.session.SessionFsm;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeDictionarySessionInitializer
implements SessionFsm.SessionInitializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BsdParser bsdParser;

    public DataTypeDictionarySessionInitializer(BsdParser bsdParser) {
        this.bsdParser = bsdParser;
    }

    public CompletableFuture<Unit> initialize(UaStackClient client, OpcUaSession session) {
        this.logger.debug("SessionInitializer: DataTypeDictionary");
        DataTypeDictionaryReader reader = new DataTypeDictionaryReader(client, session, this.bsdParser);
        return ((CompletableFuture)((CompletableFuture)reader.readDataTypeDictionaries().thenAccept(dictionaries -> dictionaries.forEach(arg_0 -> ((DataTypeManager)client.getDynamicDataTypeManager()).registerTypeDictionary(arg_0)))).thenApply(v -> Unit.VALUE)).exceptionally(ex -> {
            this.logger.warn("SessionInitializer: DataTypeDictionary", ex);
            return Unit.VALUE;
        });
    }
}

