/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.apps.basic.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.json.bind.annotation.JsonbProperty;
import org.eclipse.microprofile.graphql.DateFormat;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.eclipse.microprofile.graphql.Id;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;
import org.eclipse.microprofile.graphql.NumberFormat;
import org.eclipse.microprofile.graphql.Query;
import org.eclipse.microprofile.graphql.tck.apps.basic.api.BasicInput;
import org.eclipse.microprofile.graphql.tck.apps.basic.api.BasicInterface;
import org.eclipse.microprofile.graphql.tck.apps.basic.api.BasicType;
import org.eclipse.microprofile.graphql.tck.apps.basic.api.ScalarHolder;

@GraphQLApi
public class ScalarTestApi {
    @Query(value="testScalarsInPojo")
    public ScalarHolder getScalarHolder() {
        ScalarHolder sh = new ScalarHolder();
        short s = 123;
        sh.setShortObject(new Short(s));
        sh.setFormattedShortObject(new Short(s));
        sh.setShortPrimitive(s);
        int i = 123456789;
        sh.setIntObject(new Integer(i));
        sh.setFormattedIntObject(new Integer(i));
        sh.setIntPrimitive(i);
        long l = 123456789L;
        sh.setLongObject(new Long(l));
        sh.setFormattedLongObject(new Long(l));
        sh.setLongPrimitive(l);
        sh.setFormattedLongPrimitive(l);
        float f = 123456.79f;
        sh.setFloatObject(new Float(f));
        sh.setFormattedFloatObject(new Float(f));
        sh.setFloatPrimitive(f);
        double d = 123456.789;
        sh.setDoubleObject(new Double(d));
        sh.setFormattedDoubleObject(new Double(d));
        sh.setDoublePrimitive(d);
        byte b = 123;
        sh.setByteObject(new Byte("123"));
        sh.setFormattedByteObject(new Byte("123"));
        sh.setBytePrimitive(b);
        sh.setBigIntegerObject(BigInteger.valueOf(123456789L));
        sh.setFormattedBigIntegerObject(BigInteger.valueOf(123456789L));
        sh.setBigDecimalObject(BigDecimal.valueOf(123456.789));
        sh.setFormattedBigDecimalObject(BigDecimal.valueOf(123456.789));
        sh.setBooleanObject(false);
        sh.setBooleanPrimitive(false);
        char c = "c".charAt(0);
        sh.setCharObject(new Character(c));
        sh.setCharPrimitive(c);
        sh.setStringObject("123456789");
        sh.setCharArray("123456789".toCharArray());
        LocalDate localDate = LocalDate.parse("2019-10-23");
        sh.setDateObject(localDate);
        sh.setAnotherDateObject(localDate);
        sh.setFormattedDateObject(localDate);
        LocalTime localTime = LocalTime.parse("11:46:34.263");
        sh.setTimeObject(localTime);
        sh.setAnotherTimeObject(localTime);
        sh.setFormattedTimeObject(localTime);
        LocalDateTime localDateTime = LocalDateTime.parse("2019-10-23T11:46:34.263");
        sh.setDateTimeObject(localDateTime);
        sh.setAnotherDateTimeObject(localDateTime);
        sh.setFormattedDateTimeObject(localDateTime);
        sh.setId("123456789");
        return sh;
    }

    @Mutation
    public ScalarHolder setScalarHolder(ScalarHolder scalarHolder) {
        return scalarHolder;
    }

    @Query
    public short getShortPrimitive() {
        return this.getScalarHolder().getShortPrimitive();
    }

    @Query
    public Short getShortObject() {
        return this.getScalarHolder().getShortPrimitive();
    }

    @Query
    @JsonbProperty(value="testIntPrimitive")
    public int intPrimitive() {
        return this.getScalarHolder().getIntPrimitive();
    }

    @Query
    @Name(value="testIntObject")
    public Integer intObject() {
        return this.getScalarHolder().getIntObject();
    }

    @Query
    @JsonbProperty(value="testLongPrimitive")
    public long longPrimitive() {
        return this.getScalarHolder().getLongPrimitive();
    }

    @Query
    @Name(value="testLongObject")
    public Long longObject() {
        return this.getScalarHolder().getLongObject();
    }

    @Query
    @JsonbProperty(value="testFloatPrimitive")
    public float floatPrimitive() {
        return this.getScalarHolder().getFloatPrimitive();
    }

    @Query
    @Name(value="testFloatObject")
    public Float floatObject() {
        return this.getScalarHolder().getFloatObject();
    }

    @Query
    @JsonbProperty(value="testDoublePrimitive")
    public double doublePrimitive() {
        return this.getScalarHolder().getDoublePrimitive();
    }

    @Query
    @Name(value="testDoubleObject")
    public Double doubleObject() {
        return this.getScalarHolder().getDoubleObject();
    }

    @Query
    public boolean isBooleanPrimitive() {
        return this.getScalarHolder().isBooleanPrimitive();
    }

    @Query
    public Boolean isBooleanObject() {
        return this.getScalarHolder().getBooleanObject();
    }

    @Query
    @JsonbProperty(value="testCharPrimitive")
    public char charPrimitive() {
        return this.getScalarHolder().getCharPrimitive();
    }

    @Query
    @Name(value="testCharObject")
    public Character charObject() {
        return this.getScalarHolder().getCharObject();
    }

    @Query
    @JsonbProperty(value="testCharArray")
    public char[] charArray() {
        return this.getScalarHolder().getCharArray();
    }

    @Query
    @Name(value="testStringObject")
    public String stringObject() {
        return this.getScalarHolder().getStringObject();
    }

    @Query
    @JsonbProperty(value="testBytePrimitive")
    public byte bytePrimitive() {
        return this.getScalarHolder().getBytePrimitive();
    }

    @Query
    @Name(value="testByteObject")
    public Byte byteObject() {
        return this.getScalarHolder().getByteObject();
    }

    @Query
    @JsonbProperty(value="testBigIntegerObject")
    public BigInteger bigIntegerObject() {
        return this.getScalarHolder().getBigIntegerObject();
    }

    @Query
    @Name(value="testBigDecimalObject")
    public BigDecimal bigDecimalObject() {
        return this.getScalarHolder().getBigDecimalObject();
    }

    @Query
    @JsonbProperty(value="testDateObject")
    public LocalDate dateObject() {
        return this.getScalarHolder().getDateObject();
    }

    @Query
    @Name(value="testTimeObject")
    public LocalTime timeObject() {
        return this.getScalarHolder().getTimeObject();
    }

    @Query
    @JsonbProperty(value="testDateTimeObject")
    public LocalDateTime dateTimeObject() {
        return this.getScalarHolder().getDateTimeObject();
    }

    @Query
    @Id
    @Name(value="testId")
    public String id() {
        return this.getScalarHolder().getId();
    }

    @Query
    public BasicInterface basicMessageEcho(@Name(value="input") BasicInput input) {
        return new BasicType(input.getMessage());
    }

    @Query
    public String getaway() {
        return "Just testing a name that starts with get but is not a getter";
    }

    @Mutation
    public String settlement() {
        return "Just testing a name that starts with set but is not a setter";
    }

    @Query
    public String testNonNullParameter(@Name(value="param") @NonNull String param) {
        return param;
    }

    @Query
    @Description(value="Testing transformed date as a response")
    @DateFormat(value="dd MMM yyyy", locale="en-GB")
    public @DateFormat(value="dd MMM yyyy", locale="en-GB") LocalDate transformedDate() {
        String date = "2016-08-16";
        return LocalDate.parse(date);
    }

    @Mutation
    @Description(value="Testing transformed number as a response")
    @NumberFormat(value="number #", locale="en-GB")
    public @NumberFormat(value="number #", locale="en-GB") Integer transformedNumber(Integer input) {
        return input;
    }
}

