/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.distributed;

import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.json.JsonUtil;
import org.eclipse.keyple.distributed.AbstractNodeAdapter;
import org.eclipse.keyple.distributed.AbstractRemoteReaderAdapter;
import org.eclipse.keyple.distributed.RemoteReaderServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteReaderServerAdapter
extends AbstractRemoteReaderAdapter
implements RemoteReaderServer {
    private static final Logger logger = LoggerFactory.getLogger(RemoteReaderServerAdapter.class);
    private final String serviceId;
    private final String initialCardContentJson;
    private final String initialCardContentClassName;
    private final String inputDataJson;

    RemoteReaderServerAdapter(int clientDistributedApiLevel, int clientCoreApiLevel, String remoteReaderName, String localReaderName, String sessionId, String clientNodeId, AbstractNodeAdapter node, String serviceId, String initialCardContentJson, String initialCardContentClassName, String inputDataJson) {
        super(clientDistributedApiLevel, clientCoreApiLevel, remoteReaderName, localReaderName, sessionId, clientNodeId, node);
        this.serviceId = serviceId;
        this.initialCardContentJson = initialCardContentJson;
        this.initialCardContentClassName = initialCardContentClassName;
        this.inputDataJson = inputDataJson;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public Object getInitialCardContent() {
        if (this.initialCardContentJson != null) {
            try {
                Class<?> classOfInitialCardContent = Class.forName(this.initialCardContentClassName);
                return JsonUtil.getParser().fromJson(this.initialCardContentJson, classOfInitialCardContent);
            }
            catch (ClassNotFoundException e) {
                logger.error("Class not found for name : {}", (Object)this.initialCardContentClassName, (Object)e);
            }
        }
        return null;
    }

    @Override
    public <T> T getInputData(Class<T> inputDataClass) {
        Assert.getInstance().notNull(inputDataClass, "inputDataClass");
        return (T)(this.inputDataJson != null ? JsonUtil.getParser().fromJson(this.inputDataJson, inputDataClass) : null);
    }
}

